import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { DatabaseAction, EntityType } from 'src/enum';
export interface AuditSearch {
    action?: DatabaseAction;
    entityType?: EntityType;
    userIds: string[];
}
export declare class AuditRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAfter(since: Date, options: AuditSearch): Promise<string[]>;
    removeBefore(before: Date): Promise<void>;
}
