"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetRepository = exports.TimeBucketSize = exports.WithProperty = exports.WithoutProperty = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const lodash_1 = require("lodash");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
const misc_1 = require("../utils/misc");
const pagination_1 = require("../utils/pagination");
var WithoutProperty;
(function (WithoutProperty) {
    WithoutProperty["THUMBNAIL"] = "thumbnail";
    WithoutProperty["ENCODED_VIDEO"] = "encoded-video";
    WithoutProperty["EXIF"] = "exif";
    WithoutProperty["SMART_SEARCH"] = "smart-search";
    WithoutProperty["DUPLICATE"] = "duplicate";
    WithoutProperty["FACES"] = "faces";
    WithoutProperty["SIDECAR"] = "sidecar";
})(WithoutProperty || (exports.WithoutProperty = WithoutProperty = {}));
var WithProperty;
(function (WithProperty) {
    WithProperty["SIDECAR"] = "sidecar";
})(WithProperty || (exports.WithProperty = WithProperty = {}));
var TimeBucketSize;
(function (TimeBucketSize) {
    TimeBucketSize["DAY"] = "DAY";
    TimeBucketSize["MONTH"] = "MONTH";
})(TimeBucketSize || (exports.TimeBucketSize = TimeBucketSize = {}));
let AssetRepository = class AssetRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async upsertExif(exif) {
        const value = { ...exif, assetId: (0, database_1.asUuid)(exif.assetId) };
        await this.db
            .insertInto('exif')
            .values(value)
            .onConflict((oc) => oc.column('assetId').doUpdateSet((eb) => (0, database_1.removeUndefinedKeys)({
            description: eb.ref('excluded.description'),
            exifImageWidth: eb.ref('excluded.exifImageWidth'),
            exifImageHeight: eb.ref('excluded.exifImageHeight'),
            fileSizeInByte: eb.ref('excluded.fileSizeInByte'),
            orientation: eb.ref('excluded.orientation'),
            dateTimeOriginal: eb.ref('excluded.dateTimeOriginal'),
            modifyDate: eb.ref('excluded.modifyDate'),
            timeZone: eb.ref('excluded.timeZone'),
            latitude: eb.ref('excluded.latitude'),
            longitude: eb.ref('excluded.longitude'),
            projectionType: eb.ref('excluded.projectionType'),
            city: eb.ref('excluded.city'),
            livePhotoCID: eb.ref('excluded.livePhotoCID'),
            autoStackId: eb.ref('excluded.autoStackId'),
            state: eb.ref('excluded.state'),
            country: eb.ref('excluded.country'),
            make: eb.ref('excluded.make'),
            model: eb.ref('excluded.model'),
            lensModel: eb.ref('excluded.lensModel'),
            fNumber: eb.ref('excluded.fNumber'),
            focalLength: eb.ref('excluded.focalLength'),
            iso: eb.ref('excluded.iso'),
            exposureTime: eb.ref('excluded.exposureTime'),
            profileDescription: eb.ref('excluded.profileDescription'),
            colorspace: eb.ref('excluded.colorspace'),
            bitsPerSample: eb.ref('excluded.bitsPerSample'),
            rating: eb.ref('excluded.rating'),
            fps: eb.ref('excluded.fps'),
        }, value)))
            .execute();
    }
    async updateAllExif(ids, options) {
        if (ids.length === 0) {
            return;
        }
        await this.db.updateTable('exif').set(options).where('assetId', 'in', ids).execute();
    }
    async upsertJobStatus(...jobStatus) {
        if (jobStatus.length === 0) {
            return;
        }
        const values = jobStatus.map((row) => ({ ...row, assetId: (0, database_1.asUuid)(row.assetId) }));
        await this.db
            .insertInto('asset_job_status')
            .values(values)
            .onConflict((oc) => oc.column('assetId').doUpdateSet((eb) => (0, database_1.removeUndefinedKeys)({
            duplicatesDetectedAt: eb.ref('excluded.duplicatesDetectedAt'),
            facesRecognizedAt: eb.ref('excluded.facesRecognizedAt'),
            metadataExtractedAt: eb.ref('excluded.metadataExtractedAt'),
            previewAt: eb.ref('excluded.previewAt'),
            thumbnailAt: eb.ref('excluded.thumbnailAt'),
        }, values[0])))
            .execute();
    }
    create(asset) {
        return this.db.insertInto('assets').values(asset).returningAll().executeTakeFirstOrThrow();
    }
    createAll(assets) {
        return this.db.insertInto('assets').values(assets).returningAll().execute();
    }
    getByDayOfYear(ownerIds, { day, month }) {
        return this.db
            .with('res', (qb) => qb
            .with('today', (qb) => qb
            .selectFrom((eb) => eb
            .fn('generate_series', [
            (0, kysely_1.sql) `(select date_part('year', min(("localDateTime" at time zone 'UTC')::date))::int from assets)`,
            (0, kysely_1.sql) `date_part('year', current_date)::int - 1`,
        ])
            .as('year'))
            .select((eb) => eb.fn('make_date', [(0, kysely_1.sql) `year::int`, (0, kysely_1.sql) `${month}::int`, (0, kysely_1.sql) `${day}::int`]).as('date')))
            .selectFrom('today')
            .innerJoinLateral((qb) => qb
            .selectFrom('assets')
            .selectAll('assets')
            .innerJoin('asset_job_status', 'assets.id', 'asset_job_status.assetId')
            .where('asset_job_status.previewAt', 'is not', null)
            .where((0, kysely_1.sql) `(assets."localDateTime" at time zone 'UTC')::date`, '=', (0, kysely_1.sql) `today.date`)
            .where('assets.ownerId', '=', (0, database_1.anyUuid)(ownerIds))
            .where('assets.isVisible', '=', true)
            .where('assets.isArchived', '=', false)
            .where((eb) => eb.exists((qb) => qb
            .selectFrom('asset_files')
            .whereRef('assetId', '=', 'assets.id')
            .where('asset_files.type', '=', enum_1.AssetFileType.PREVIEW)))
            .where('assets.deletedAt', 'is', null)
            .orderBy((0, kysely_1.sql) `(assets."localDateTime" at time zone 'UTC')::date`, 'desc')
            .limit(20)
            .as('a'), (join) => join.onTrue())
            .innerJoin('exif', 'a.id', 'exif.assetId')
            .selectAll('a')
            .select((eb) => eb.fn.toJson(eb.table('exif')).as('exifInfo')))
            .selectFrom('res')
            .select((0, kysely_1.sql) `date_part('year', ("localDateTime" at time zone 'UTC')::date)::int`.as('year'))
            .select((eb) => eb.fn.jsonAgg(eb.table('res')).as('assets'))
            .groupBy((0, kysely_1.sql) `("localDateTime" at time zone 'UTC')::date`)
            .orderBy((0, kysely_1.sql) `("localDateTime" at time zone 'UTC')::date`, 'desc')
            .execute();
    }
    getByIds(ids) {
        return this.db.selectFrom('assets').selectAll('assets').where('assets.id', '=', (0, database_1.anyUuid)(ids)).execute();
    }
    getByIdsWithAllRelationsButStacks(ids) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .select(database_1.withFacesAndPeople)
            .select(database_1.withTags)
            .$call(database_1.withExif)
            .leftJoin('asset_stack', 'asset_stack.id', 'assets.stackId')
            .where('assets.id', '=', (0, database_1.anyUuid)(ids))
            .execute();
    }
    async deleteAll(ownerId) {
        await this.db.deleteFrom('assets').where('ownerId', '=', ownerId).execute();
    }
    async getByDeviceIds(ownerId, deviceId, deviceAssetIds) {
        const assets = await this.db
            .selectFrom('assets')
            .select(['deviceAssetId'])
            .where('deviceAssetId', 'in', deviceAssetIds)
            .where('deviceId', '=', deviceId)
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .execute();
        return assets.map((asset) => asset.deviceAssetId);
    }
    getByUserId(pagination, userId, options = {}) {
        return this.getAll(pagination, { ...options, userIds: [userId] });
    }
    getByLibraryIdAndOriginalPath(libraryId, originalPath) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .where('libraryId', '=', (0, database_1.asUuid)(libraryId))
            .where('originalPath', '=', originalPath)
            .limit(1)
            .executeTakeFirst();
    }
    async getAll(pagination, { orderDirection, ...options } = {}) {
        const builder = (0, database_1.searchAssetBuilder)(this.db, options)
            .select(database_1.withFiles)
            .orderBy('assets.createdAt', orderDirection ?? 'asc')
            .limit(pagination.take + 1)
            .offset(pagination.skip ?? 0);
        const items = await builder.execute();
        return (0, pagination_1.paginationHelper)(items, pagination.take);
    }
    async getAllByDeviceId(ownerId, deviceId) {
        const items = await this.db
            .selectFrom('assets')
            .select(['deviceAssetId'])
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('deviceId', '=', deviceId)
            .where('isVisible', '=', true)
            .where('deletedAt', 'is', null)
            .execute();
        return items.map((asset) => asset.deviceAssetId);
    }
    async getLivePhotoCount(motionId) {
        const [{ count }] = await this.db
            .selectFrom('assets')
            .select((eb) => eb.fn.countAll().as('count'))
            .where('livePhotoVideoId', '=', (0, database_1.asUuid)(motionId))
            .execute();
        return count;
    }
    getById(id, { exifInfo, faces, files, library, owner, smartSearch, stack, tags } = {}) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .where('assets.id', '=', (0, database_1.asUuid)(id))
            .$if(!!exifInfo, database_1.withExif)
            .$if(!!faces, (qb) => qb.select(faces?.person ? database_1.withFacesAndPeople : database_1.withFaces).$narrowType())
            .$if(!!library, (qb) => qb.select(database_1.withLibrary))
            .$if(!!owner, (qb) => qb.select(database_1.withOwner))
            .$if(!!smartSearch, database_1.withSmartSearch)
            .$if(!!stack, (qb) => qb
            .leftJoin('asset_stack', 'asset_stack.id', 'assets.stackId')
            .$if(!stack.assets, (qb) => qb.select((eb) => eb.fn.toJson(eb.table('asset_stack')).$castTo().as('stack')))
            .$if(!!stack.assets, (qb) => qb
            .leftJoinLateral((eb) => eb
            .selectFrom('assets as stacked')
            .selectAll('asset_stack')
            .select((eb) => eb.fn('array_agg', [eb.table('stacked')]).as('assets'))
            .whereRef('stacked.stackId', '=', 'asset_stack.id')
            .whereRef('stacked.id', '!=', 'asset_stack.primaryAssetId')
            .where('stacked.deletedAt', 'is', null)
            .where('stacked.isArchived', '=', false)
            .groupBy('asset_stack.id')
            .as('stacked_assets'), (join) => join.on('asset_stack.id', 'is not', null))
            .select((eb) => eb.fn.toJson(eb.table('stacked_assets')).$castTo().as('stack'))))
            .$if(!!files, (qb) => qb.select(database_1.withFiles))
            .$if(!!tags, (qb) => qb.select(database_1.withTags))
            .limit(1)
            .executeTakeFirst();
    }
    async updateAll(ids, options) {
        if (ids.length === 0) {
            return;
        }
        await this.db.updateTable('assets').set(options).where('id', '=', (0, database_1.anyUuid)(ids)).execute();
    }
    async updateByLibraryId(libraryId, options) {
        await this.db.updateTable('assets').set(options).where('libraryId', '=', (0, database_1.asUuid)(libraryId)).execute();
    }
    async updateDuplicates(options) {
        await this.db
            .updateTable('assets')
            .set({ duplicateId: options.targetDuplicateId })
            .where((eb) => eb.or([eb('duplicateId', '=', (0, database_1.anyUuid)(options.duplicateIds)), eb('id', '=', (0, database_1.anyUuid)(options.assetIds))]))
            .execute();
    }
    async update(asset) {
        const value = (0, lodash_1.omitBy)(asset, lodash_1.isUndefined);
        delete value.id;
        if (!(0, lodash_1.isEmpty)(value)) {
            return this.db
                .with('assets', (qb) => qb.updateTable('assets').set(asset).where('id', '=', (0, database_1.asUuid)(asset.id)).returningAll())
                .selectFrom('assets')
                .selectAll('assets')
                .$call(database_1.withExif)
                .$call((qb) => qb.select(database_1.withFacesAndPeople))
                .executeTakeFirst();
        }
        return this.getById(asset.id, { exifInfo: true, faces: { person: true } });
    }
    async remove(asset) {
        await this.db.deleteFrom('assets').where('id', '=', (0, database_1.asUuid)(asset.id)).execute();
    }
    getByChecksum({ ownerId, libraryId, checksum }) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('checksum', '=', checksum)
            .$call((qb) => (libraryId ? qb.where('libraryId', '=', (0, database_1.asUuid)(libraryId)) : qb.where('libraryId', 'is', null)))
            .limit(1)
            .executeTakeFirst();
    }
    getByChecksums(userId, checksums) {
        return this.db
            .selectFrom('assets')
            .select(['id', 'checksum', 'deletedAt'])
            .where('ownerId', '=', (0, database_1.asUuid)(userId))
            .where('checksum', 'in', checksums)
            .execute();
    }
    async getUploadAssetIdByChecksum(ownerId, checksum) {
        const asset = await this.db
            .selectFrom('assets')
            .select('id')
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('checksum', '=', checksum)
            .where('libraryId', 'is', null)
            .limit(1)
            .executeTakeFirst();
        return asset?.id;
    }
    findLivePhotoMatch(options) {
        const { ownerId, otherAssetId, livePhotoCID, type } = options;
        return this.db
            .selectFrom('assets')
            .select(['assets.id', 'assets.ownerId'])
            .innerJoin('exif', 'assets.id', 'exif.assetId')
            .where('id', '!=', (0, database_1.asUuid)(otherAssetId))
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('type', '=', type)
            .where('exif.livePhotoCID', '=', livePhotoCID)
            .limit(1)
            .executeTakeFirst();
    }
    async getWithout(pagination, property) {
        const items = await this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$if(property === WithoutProperty.DUPLICATE, (qb) => qb
            .innerJoin('asset_job_status as job_status', 'assets.id', 'job_status.assetId')
            .where('job_status.duplicatesDetectedAt', 'is', null)
            .where('job_status.previewAt', 'is not', null)
            .where((eb) => eb.exists(eb.selectFrom('smart_search').where('assetId', '=', eb.ref('assets.id'))))
            .where('assets.isVisible', '=', true))
            .$if(property === WithoutProperty.ENCODED_VIDEO, (qb) => qb
            .where('assets.type', '=', enum_1.AssetType.VIDEO)
            .where((eb) => eb.or([eb('assets.encodedVideoPath', 'is', null), eb('assets.encodedVideoPath', '=', '')])))
            .$if(property === WithoutProperty.EXIF, (qb) => qb
            .leftJoin('asset_job_status as job_status', 'assets.id', 'job_status.assetId')
            .where((eb) => eb.or([eb('job_status.metadataExtractedAt', 'is', null), eb('assetId', 'is', null)]))
            .where('assets.isVisible', '=', true))
            .$if(property === WithoutProperty.FACES, (qb) => qb
            .innerJoin('asset_job_status as job_status', 'assetId', 'assets.id')
            .where('job_status.previewAt', 'is not', null)
            .where('job_status.facesRecognizedAt', 'is', null)
            .where('assets.isVisible', '=', true))
            .$if(property === WithoutProperty.SIDECAR, (qb) => qb
            .where((eb) => eb.or([eb('assets.sidecarPath', '=', ''), eb('assets.sidecarPath', 'is', null)]))
            .where('assets.isVisible', '=', true))
            .$if(property === WithoutProperty.SMART_SEARCH, (qb) => qb
            .innerJoin('asset_job_status as job_status', 'assetId', 'assets.id')
            .where('job_status.previewAt', 'is not', null)
            .where('assets.isVisible', '=', true)
            .where((eb) => eb.not((eb) => eb.exists(eb.selectFrom('smart_search').whereRef('assetId', '=', 'assets.id')))))
            .$if(property === WithoutProperty.THUMBNAIL, (qb) => qb
            .innerJoin('asset_job_status as job_status', 'assetId', 'assets.id')
            .where('assets.isVisible', '=', true)
            .where((eb) => eb.or([
            eb('job_status.previewAt', 'is', null),
            eb('job_status.thumbnailAt', 'is', null),
            eb('assets.thumbhash', 'is', null),
        ])))
            .where('deletedAt', 'is', null)
            .limit(pagination.take + 1)
            .offset(pagination.skip ?? 0)
            .orderBy('createdAt')
            .execute();
        return (0, pagination_1.paginationHelper)(items, pagination.take);
    }
    getStatistics(ownerId, { isArchived, isFavorite, isTrashed }) {
        return this.db
            .selectFrom('assets')
            .select((eb) => eb.fn.countAll().filterWhere('type', '=', enum_1.AssetType.AUDIO).as(enum_1.AssetType.AUDIO))
            .select((eb) => eb.fn.countAll().filterWhere('type', '=', enum_1.AssetType.IMAGE).as(enum_1.AssetType.IMAGE))
            .select((eb) => eb.fn.countAll().filterWhere('type', '=', enum_1.AssetType.VIDEO).as(enum_1.AssetType.VIDEO))
            .select((eb) => eb.fn.countAll().filterWhere('type', '=', enum_1.AssetType.OTHER).as(enum_1.AssetType.OTHER))
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('isVisible', '=', true)
            .$if(isArchived !== undefined, (qb) => qb.where('isArchived', '=', isArchived))
            .$if(isFavorite !== undefined, (qb) => qb.where('isFavorite', '=', isFavorite))
            .$if(!!isTrashed, (qb) => qb.where('assets.status', '!=', enum_1.AssetStatus.DELETED))
            .where('deletedAt', isTrashed ? 'is not' : 'is', null)
            .executeTakeFirstOrThrow();
    }
    getRandom(userIds, take) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$call(database_1.withExif)
            .where('ownerId', '=', (0, database_1.anyUuid)(userIds))
            .where('isVisible', '=', true)
            .where('deletedAt', 'is', null)
            .orderBy((eb) => eb.fn('random'))
            .limit(take)
            .execute();
    }
    async getTimeBuckets(options) {
        return this.db
            .with('assets', (qb) => qb
            .selectFrom('assets')
            .select((0, database_1.truncatedDate)(options.size).as('timeBucket'))
            .$if(!!options.isTrashed, (qb) => qb.where('assets.status', '!=', enum_1.AssetStatus.DELETED))
            .where('assets.deletedAt', options.isTrashed ? 'is not' : 'is', null)
            .where('assets.isVisible', '=', true)
            .$if(!!options.albumId, (qb) => qb
            .innerJoin('albums_assets_assets', 'assets.id', 'albums_assets_assets.assetsId')
            .where('albums_assets_assets.albumsId', '=', (0, database_1.asUuid)(options.albumId)))
            .$if(!!options.personId, (qb) => (0, database_1.hasPeople)(qb, [options.personId]))
            .$if(!!options.withStacked, (qb) => qb
            .leftJoin('asset_stack', (join) => join
            .onRef('asset_stack.id', '=', 'assets.stackId')
            .onRef('asset_stack.primaryAssetId', '=', 'assets.id'))
            .where((eb) => eb.or([eb('assets.stackId', 'is', null), eb(eb.table('asset_stack'), 'is not', null)])))
            .$if(!!options.userIds, (qb) => qb.where('assets.ownerId', '=', (0, database_1.anyUuid)(options.userIds)))
            .$if(options.isArchived !== undefined, (qb) => qb.where('assets.isArchived', '=', options.isArchived))
            .$if(options.isFavorite !== undefined, (qb) => qb.where('assets.isFavorite', '=', options.isFavorite))
            .$if(!!options.assetType, (qb) => qb.where('assets.type', '=', options.assetType))
            .$if(options.isDuplicate !== undefined, (qb) => qb.where('assets.duplicateId', options.isDuplicate ? 'is not' : 'is', null))
            .$if(!!options.tagId, (qb) => (0, database_1.withTagId)(qb, options.tagId)))
            .selectFrom('assets')
            .select('timeBucket')
            .select((eb) => eb.fn.countAll().as('count'))
            .groupBy('timeBucket')
            .orderBy('timeBucket', options.order ?? 'desc')
            .execute();
    }
    async getTimeBucket(timeBucket, options) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$call(database_1.withExif)
            .$if(!!options.albumId, (qb) => qb
            .innerJoin('albums_assets_assets', 'albums_assets_assets.assetsId', 'assets.id')
            .where('albums_assets_assets.albumsId', '=', options.albumId))
            .$if(!!options.personId, (qb) => (0, database_1.hasPeople)(qb, [options.personId]))
            .$if(!!options.userIds, (qb) => qb.where('assets.ownerId', '=', (0, database_1.anyUuid)(options.userIds)))
            .$if(options.isArchived !== undefined, (qb) => qb.where('assets.isArchived', '=', options.isArchived))
            .$if(options.isFavorite !== undefined, (qb) => qb.where('assets.isFavorite', '=', options.isFavorite))
            .$if(!!options.withStacked, (qb) => qb
            .leftJoin('asset_stack', 'asset_stack.id', 'assets.stackId')
            .where((eb) => eb.or([eb('asset_stack.primaryAssetId', '=', eb.ref('assets.id')), eb('assets.stackId', 'is', null)]))
            .leftJoinLateral((eb) => eb
            .selectFrom('assets as stacked')
            .selectAll('asset_stack')
            .select((eb) => eb.fn.count(eb.table('stacked')).as('assetCount'))
            .whereRef('stacked.stackId', '=', 'asset_stack.id')
            .where('stacked.deletedAt', 'is', null)
            .where('stacked.isArchived', '=', false)
            .groupBy('asset_stack.id')
            .as('stacked_assets'), (join) => join.on('asset_stack.id', 'is not', null))
            .select((eb) => eb.fn.toJson(eb.table('stacked_assets').$castTo()).as('stack')))
            .$if(!!options.assetType, (qb) => qb.where('assets.type', '=', options.assetType))
            .$if(options.isDuplicate !== undefined, (qb) => qb.where('assets.duplicateId', options.isDuplicate ? 'is not' : 'is', null))
            .$if(!!options.isTrashed, (qb) => qb.where('assets.status', '!=', enum_1.AssetStatus.DELETED))
            .$if(!!options.tagId, (qb) => (0, database_1.withTagId)(qb, options.tagId))
            .where('assets.deletedAt', options.isTrashed ? 'is not' : 'is', null)
            .where('assets.isVisible', '=', true)
            .where((0, database_1.truncatedDate)(options.size), '=', timeBucket.replace(/^[+-]/, ''))
            .orderBy('assets.localDateTime', options.order ?? 'desc')
            .execute();
    }
    getDuplicates(userId) {
        return (this.db
            .with('duplicates', (qb) => qb
            .selectFrom('assets')
            .leftJoinLateral((qb) => qb
            .selectFrom('exif')
            .selectAll('assets')
            .select((eb) => eb.table('exif').as('exifInfo'))
            .whereRef('exif.assetId', '=', 'assets.id')
            .as('asset'), (join) => join.onTrue())
            .select('assets.duplicateId')
            .select((eb) => eb
            .fn('jsonb_agg', [eb.table('asset')])
            .$castTo()
            .as('assets'))
            .where('assets.ownerId', '=', (0, database_1.asUuid)(userId))
            .where('assets.duplicateId', 'is not', null)
            .$narrowType()
            .where('assets.deletedAt', 'is', null)
            .where('assets.isVisible', '=', true)
            .where('assets.stackId', 'is', null)
            .groupBy('assets.duplicateId'))
            .with('unique', (qb) => qb
            .selectFrom('duplicates')
            .select('duplicateId')
            .where((eb) => eb(eb.fn('jsonb_array_length', ['assets']), '=', 1)))
            .with('removed_unique', (qb) => qb
            .updateTable('assets')
            .set({ duplicateId: null })
            .from('unique')
            .whereRef('assets.duplicateId', '=', 'unique.duplicateId'))
            .selectFrom('duplicates')
            .selectAll()
            .where(({ not, exists }) => not(exists((eb) => eb.selectFrom('unique').whereRef('unique.duplicateId', '=', 'duplicates.duplicateId'))))
            .execute());
    }
    async getAssetIdByCity(ownerId, { minAssetsPerField, maxFields }) {
        const items = await this.db
            .with('cities', (qb) => qb
            .selectFrom('exif')
            .select('city')
            .where('city', 'is not', null)
            .groupBy('city')
            .having((eb) => eb.fn('count', [eb.ref('assetId')]), '>=', minAssetsPerField))
            .selectFrom('assets')
            .innerJoin('exif', 'assets.id', 'exif.assetId')
            .innerJoin('cities', 'exif.city', 'cities.city')
            .distinctOn('exif.city')
            .select(['assetId as data', 'exif.city as value'])
            .where('ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('isVisible', '=', true)
            .where('isArchived', '=', false)
            .where('type', '=', enum_1.AssetType.IMAGE)
            .where('deletedAt', 'is', null)
            .limit(maxFields)
            .execute();
        return { fieldName: 'exifInfo.city', items: items };
    }
    getAllForUserFullSync(options) {
        const { ownerId, lastId, updatedUntil, limit } = options;
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$call(database_1.withExif)
            .leftJoin('asset_stack', 'asset_stack.id', 'assets.stackId')
            .leftJoinLateral((eb) => eb
            .selectFrom('assets as stacked')
            .selectAll('asset_stack')
            .select((eb) => eb.fn.count(eb.table('stacked')).as('assetCount'))
            .whereRef('stacked.stackId', '=', 'asset_stack.id')
            .groupBy('asset_stack.id')
            .as('stacked_assets'), (join) => join.on('asset_stack.id', 'is not', null))
            .select((eb) => eb.fn.toJson(eb.table('stacked_assets')).$castTo().as('stack'))
            .where('assets.ownerId', '=', (0, database_1.asUuid)(ownerId))
            .where('assets.isVisible', '=', true)
            .where('assets.updatedAt', '<=', updatedUntil)
            .$if(!!lastId, (qb) => qb.where('assets.id', '>', lastId))
            .orderBy('assets.id')
            .limit(limit)
            .execute();
    }
    async getChangedDeltaSync(options) {
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$call(database_1.withExif)
            .leftJoin('asset_stack', 'asset_stack.id', 'assets.stackId')
            .leftJoinLateral((eb) => eb
            .selectFrom('assets as stacked')
            .selectAll('asset_stack')
            .select((eb) => eb.fn.count(eb.table('stacked')).as('assetCount'))
            .whereRef('stacked.stackId', '=', 'asset_stack.id')
            .groupBy('asset_stack.id')
            .as('stacked_assets'), (join) => join.on('asset_stack.id', 'is not', null))
            .select((eb) => eb.fn.toJson(eb.table('stacked_assets').$castTo()).as('stack'))
            .where('assets.ownerId', '=', (0, database_1.anyUuid)(options.userIds))
            .where('assets.isVisible', '=', true)
            .where('assets.updatedAt', '>', options.updatedAfter)
            .limit(options.limit)
            .execute();
    }
    async upsertFile(file) {
        const value = { ...file, assetId: (0, database_1.asUuid)(file.assetId) };
        await this.db
            .insertInto('asset_files')
            .values(value)
            .onConflict((oc) => oc.columns(['assetId', 'type']).doUpdateSet((eb) => ({
            path: eb.ref('excluded.path'),
        })))
            .execute();
    }
    async upsertFiles(files) {
        if (files.length === 0) {
            return;
        }
        const values = files.map((row) => ({ ...row, assetId: (0, database_1.asUuid)(row.assetId) }));
        await this.db
            .insertInto('asset_files')
            .values(values)
            .onConflict((oc) => oc.columns(['assetId', 'type']).doUpdateSet((eb) => ({
            path: eb.ref('excluded.path'),
        })))
            .execute();
    }
    async deleteFiles(files) {
        if (files.length === 0) {
            return;
        }
        await this.db
            .deleteFrom('asset_files')
            .where('id', '=', (0, database_1.anyUuid)(files.map((file) => file.id)))
            .execute();
    }
    async detectOfflineExternalAssets(libraryId, importPaths, exclusionPatterns) {
        const paths = importPaths.map((importPath) => `${importPath}%`);
        const exclusions = exclusionPatterns.map((pattern) => (0, misc_1.globToSqlPattern)(pattern));
        return this.db
            .updateTable('assets')
            .set({
            isOffline: true,
            deletedAt: new Date(),
        })
            .where('isOffline', '=', false)
            .where('isExternal', '=', true)
            .where('libraryId', '=', (0, database_1.asUuid)(libraryId))
            .where((eb) => eb.or([
            eb.not(eb.or(paths.map((path) => eb('originalPath', 'like', path)))),
            eb.or(exclusions.map((path) => eb('originalPath', 'like', path))),
        ]))
            .executeTakeFirstOrThrow();
    }
    async filterNewExternalAssetPaths(libraryId, paths) {
        const result = await this.db
            .selectFrom((0, database_1.unnest)(paths).as('path'))
            .select('path')
            .where((eb) => eb.not(eb.exists(this.db
            .selectFrom('assets')
            .select('originalPath')
            .whereRef('assets.originalPath', '=', eb.ref('path'))
            .where('libraryId', '=', (0, database_1.asUuid)(libraryId))
            .where('isExternal', '=', true))))
            .execute();
        return result.map((row) => row.path);
    }
    async getLibraryAssetCount(libraryId) {
        const { count } = await this.db
            .selectFrom('assets')
            .select((eb) => eb.fn.countAll().as('count'))
            .where('libraryId', '=', (0, database_1.asUuid)(libraryId))
            .executeTakeFirstOrThrow();
        return count;
    }
};
exports.AssetRepository = AssetRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], { model: decorators_1.DummyValue.STRING }] }),
    (0, decorators_1.Chunked)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "updateAllExif", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { day: 1, month: 1 }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByDayOfYear", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedArray)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedArray)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByIdsWithAllRelationsButStacks", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "deleteAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByLibraryIdAndOriginalPath", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getAllByDeviceId", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getLivePhotoCount", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], { deviceId: decorators_1.DummyValue.STRING }] }),
    (0, decorators_1.Chunked)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "updateAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [{ targetDuplicateId: decorators_1.DummyValue.UUID, duplicateIds: [decorators_1.DummyValue.UUID], assetIds: [decorators_1.DummyValue.UUID] }],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "updateDuplicates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ ownerId: decorators_1.DummyValue.UUID, libraryId: decorators_1.DummyValue.UUID, checksum: decorators_1.DummyValue.BUFFER }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByChecksum", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.BUFFER]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getByChecksums", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.BUFFER] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Buffer]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getUploadAssetIdByChecksum", null);
__decorate([
    (0, decorators_1.GenerateSql)(...Object.values(WithProperty).map((property) => ({
        name: property,
        params: [decorators_1.DummyValue.PAGINATION, property],
    }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getWithout", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ size: TimeBucketSize.MONTH }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getTimeBuckets", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.TIME_BUCKET, { size: TimeBucketSize.MONTH, withStacked: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getTimeBucket", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getDuplicates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { minAssetsPerField: 5, maxFields: 12 }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getAssetIdByCity", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            {
                ownerId: decorators_1.DummyValue.UUID,
                lastId: decorators_1.DummyValue.UUID,
                updatedUntil: decorators_1.DummyValue.DATE,
                limit: 10,
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetRepository.prototype, "getAllForUserFullSync", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ userIds: [decorators_1.DummyValue.UUID], updatedAfter: decorators_1.DummyValue.DATE, limit: 100 }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "getChangedDeltaSync", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [{ libraryId: decorators_1.DummyValue.UUID, importPaths: [decorators_1.DummyValue.STRING], exclusionPatterns: [decorators_1.DummyValue.STRING] }],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array, Array]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "detectOfflineExternalAssets", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [{ libraryId: decorators_1.DummyValue.UUID, paths: [decorators_1.DummyValue.STRING] }],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AssetRepository.prototype, "filterNewExternalAssetPaths", null);
exports.AssetRepository = AssetRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AssetRepository);
//# sourceMappingURL=asset.repository.js.map