import { Insertable, Kysely, Selectable, UpdateResult, Updateable } from 'kysely';
import { Stack } from 'src/database';
import { AssetFiles, AssetJobStatus, Assets, DB, Exif } from 'src/db';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { AssetFileType, AssetOrder, AssetStatus, AssetType } from 'src/enum';
import { AssetSearchOptions, SearchExploreItem } from 'src/repositories/search.repository';
import { PaginationOptions } from 'src/utils/pagination';
export type AssetStats = Record<AssetType, number>;
export interface AssetStatsOptions {
    isFavorite?: boolean;
    isArchived?: boolean;
    isTrashed?: boolean;
}
export interface LivePhotoSearchOptions {
    ownerId: string;
    libraryId?: string | null;
    livePhotoCID: string;
    otherAssetId: string;
    type: AssetType;
}
export declare enum WithoutProperty {
    THUMBNAIL = "thumbnail",
    ENCODED_VIDEO = "encoded-video",
    EXIF = "exif",
    SMART_SEARCH = "smart-search",
    DUPLICATE = "duplicate",
    FACES = "faces",
    SIDECAR = "sidecar"
}
export declare enum WithProperty {
    SIDECAR = "sidecar"
}
export declare enum TimeBucketSize {
    DAY = "DAY",
    MONTH = "MONTH"
}
export interface AssetBuilderOptions {
    isArchived?: boolean;
    isFavorite?: boolean;
    isTrashed?: boolean;
    isDuplicate?: boolean;
    albumId?: string;
    tagId?: string;
    personId?: string;
    userIds?: string[];
    withStacked?: boolean;
    exifInfo?: boolean;
    status?: AssetStatus;
    assetType?: AssetType;
}
export interface TimeBucketOptions extends AssetBuilderOptions {
    size: TimeBucketSize;
    order?: AssetOrder;
}
export interface TimeBucketItem {
    timeBucket: string;
    count: number;
}
export interface MonthDay {
    day: number;
    month: number;
}
export interface AssetExploreFieldOptions {
    maxFields: number;
    minAssetsPerField: number;
}
export interface AssetFullSyncOptions {
    ownerId: string;
    lastId?: string;
    updatedUntil: Date;
    limit: number;
}
export interface AssetDeltaSyncOptions {
    userIds: string[];
    updatedAfter: Date;
    limit: number;
}
export interface AssetUpdateDuplicateOptions {
    targetDuplicateId: string | null;
    assetIds: string[];
    duplicateIds: string[];
}
export interface UpsertFileOptions {
    assetId: string;
    type: AssetFileType;
    path: string;
}
export interface AssetGetByChecksumOptions {
    ownerId: string;
    checksum: Buffer;
    libraryId?: string;
}
export interface GetByIdsRelations {
    exifInfo?: boolean;
    faces?: {
        person?: boolean;
        withDeleted?: boolean;
    };
    files?: boolean;
    library?: boolean;
    owner?: boolean;
    smartSearch?: boolean;
    stack?: {
        assets?: boolean;
    };
    tags?: boolean;
}
export interface DuplicateGroup {
    duplicateId: string;
    assets: MapAsset[];
}
export interface DayOfYearAssets {
    yearsAgo: number;
    assets: MapAsset[];
}
export declare class AssetRepository {
    private db;
    constructor(db: Kysely<DB>);
    upsertExif(exif: Insertable<Exif>): Promise<void>;
    updateAllExif(ids: string[], options: Updateable<Exif>): Promise<void>;
    upsertJobStatus(...jobStatus: Insertable<AssetJobStatus>[]): Promise<void>;
    create(asset: Insertable<Assets>): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    }>;
    createAll(assets: Insertable<Assets>[]): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    }[]>;
    getByDayOfYear(ownerIds: string[], { day, month }: MonthDay): Promise<{
        year: number;
        assets: {
            id: string;
            type: AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            exifInfo: {
                description: string;
                state: string | null;
                fileSizeInByte: number | null;
                assetId: string;
                updateId: string;
                updatedAt: Date;
                autoStackId: string | null;
                bitsPerSample: number | null;
                city: string | null;
                colorspace: string | null;
                country: string | null;
                dateTimeOriginal: Date | null;
                exifImageHeight: number | null;
                exifImageWidth: number | null;
                exposureTime: string | null;
                fNumber: number | null;
                focalLength: number | null;
                fps: number | null;
                iso: number | null;
                latitude: number | null;
                lensModel: string | null;
                livePhotoCID: string | null;
                longitude: number | null;
                make: string | null;
                model: string | null;
                modifyDate: Date | null;
                orientation: string | null;
                profileDescription: string | null;
                projectionType: string | null;
                rating: number | null;
                timeZone: string | null;
            };
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
    }[]>;
    getByIds(ids: string[]): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    }[]>;
    getByIdsWithAllRelationsButStacks(ids: string[]): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        faces: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
            person: import("src/database").Person;
        }[];
        tags: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[];
        exifInfo: import("src/database").Exif | null;
    }[]>;
    deleteAll(ownerId: string): Promise<void>;
    getByDeviceIds(ownerId: string, deviceId: string, deviceAssetIds: string[]): Promise<string[]>;
    getByUserId(pagination: PaginationOptions, userId: string, options?: Omit<AssetSearchOptions, 'userIds'>): Promise<import("src/utils/pagination").PaginationResult<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo?: import("src/database").Exif | undefined;
        faces?: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
            person: import("src/database").Person;
        }[] | undefined;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    }>>;
    getByLibraryIdAndOriginalPath(libraryId: string, originalPath: string): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    } | undefined>;
    getAll(pagination: PaginationOptions, { orderDirection, ...options }?: AssetSearchOptions): Promise<import("src/utils/pagination").PaginationResult<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo?: import("src/database").Exif | undefined;
        faces?: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
            person: import("src/database").Person;
        }[] | undefined;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    }>>;
    getAllByDeviceId(ownerId: string, deviceId: string): Promise<string[]>;
    getLivePhotoCount(motionId: string): Promise<number>;
    getById(id: string, { exifInfo, faces, files, library, owner, smartSearch, stack, tags }?: GetByIdsRelations): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo?: import("src/database").Exif | null | undefined;
        faces?: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
        }[] | undefined;
        library?: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            exclusionPatterns: string[];
            importPaths: string[];
            refreshedAt: Date | null;
        } | null | undefined;
        owner?: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null | undefined;
        smartSearch?: {
            assetId: string;
            embedding: string;
        } | null | undefined;
        stack?: Stack | null | undefined;
        files?: {
            id: string;
            path: string;
            type: AssetFileType;
        }[] | undefined;
        tags?: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[] | undefined;
    } | undefined>;
    updateAll(ids: string[], options: Updateable<Assets>): Promise<void>;
    updateByLibraryId(libraryId: string, options: Updateable<Assets>): Promise<void>;
    updateDuplicates(options: AssetUpdateDuplicateOptions): Promise<void>;
    update(asset: Updateable<Assets> & {
        id: string;
    }): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo?: import("src/database").Exif | null | undefined;
        faces?: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
        }[] | undefined;
        library?: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            exclusionPatterns: string[];
            importPaths: string[];
            refreshedAt: Date | null;
        } | null | undefined;
        owner?: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null | undefined;
        smartSearch?: {
            assetId: string;
            embedding: string;
        } | null | undefined;
        stack?: Stack | null | undefined;
        files?: {
            id: string;
            path: string;
            type: AssetFileType;
        }[] | undefined;
        tags?: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[] | undefined;
    } | {
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("src/database").Exif | null;
        faces: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
            person: import("src/database").Person;
        }[];
    } | undefined>;
    remove(asset: {
        id: string;
    }): Promise<void>;
    getByChecksum({ ownerId, libraryId, checksum }: AssetGetByChecksumOptions): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    } | undefined>;
    getByChecksums(userId: string, checksums: Buffer[]): Promise<{
        id: string;
        deletedAt: Date | null;
        checksum: Buffer<ArrayBufferLike>;
    }[]>;
    getUploadAssetIdByChecksum(ownerId: string, checksum: Buffer): Promise<string | undefined>;
    findLivePhotoMatch(options: LivePhotoSearchOptions): Promise<{
        id: string;
        ownerId: string;
    } | undefined>;
    getWithout(pagination: PaginationOptions, property: WithoutProperty): Promise<import("src/utils/pagination").PaginationResult<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
    }>>;
    getStatistics(ownerId: string, { isArchived, isFavorite, isTrashed }: AssetStatsOptions): Promise<AssetStats>;
    getRandom(userIds: string[], take: number): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("src/database").Exif | null;
    }[]>;
    getTimeBuckets(options: TimeBucketOptions): Promise<TimeBucketItem[]>;
    getTimeBucket(timeBucket: string, options: TimeBucketOptions): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("src/database").Exif | null;
        stack?: Stack | null | undefined;
    }[]>;
    getDuplicates(userId: string): Promise<{
        assets: MapAsset[];
        duplicateId: string;
    }[]>;
    getAssetIdByCity(ownerId: string, { minAssetsPerField, maxFields }: AssetExploreFieldOptions): Promise<SearchExploreItem<string>>;
    getAllForUserFullSync(options: AssetFullSyncOptions): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("src/database").Exif | null;
        stack: Stack | null;
    }[]>;
    getChangedDeltaSync(options: AssetDeltaSyncOptions): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("src/database").Exif | null;
        stack: Stack | null;
    }[]>;
    upsertFile(file: Pick<Insertable<AssetFiles>, 'assetId' | 'path' | 'type'>): Promise<void>;
    upsertFiles(files: Pick<Insertable<AssetFiles>, 'assetId' | 'path' | 'type'>[]): Promise<void>;
    deleteFiles(files: Pick<Selectable<AssetFiles>, 'id'>[]): Promise<void>;
    detectOfflineExternalAssets(libraryId: string, importPaths: string[], exclusionPatterns: string[]): Promise<UpdateResult>;
    filterNewExternalAssetPaths(libraryId: string, paths: string[]): Promise<string[]>;
    getLibraryAssetCount(libraryId: string): Promise<number>;
}
