"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetJobRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_2 = require("../utils/database");
let AssetJobRepository = class AssetJobRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getForSearchDuplicatesJob(id) {
        return this.db
            .selectFrom('assets')
            .where('assets.id', '=', (0, database_2.asUuid)(id))
            .leftJoin('smart_search', 'assets.id', 'smart_search.assetId')
            .select((eb) => [
            'id',
            'type',
            'ownerId',
            'duplicateId',
            'stackId',
            'isVisible',
            'smart_search.embedding',
            (0, database_2.withFiles)(eb, enum_1.AssetFileType.PREVIEW),
        ])
            .limit(1)
            .executeTakeFirst();
    }
    getForSidecarWriteJob(id) {
        return this.db
            .selectFrom('assets')
            .where('assets.id', '=', (0, database_2.asUuid)(id))
            .select((eb) => [
            'id',
            'sidecarPath',
            'originalPath',
            (0, postgres_1.jsonArrayFrom)(eb
                .selectFrom('tags')
                .select(['tags.value'])
                .innerJoin('tag_asset', 'tags.id', 'tag_asset.tagsId')
                .whereRef('assets.id', '=', 'tag_asset.assetsId')).as('tags'),
        ])
            .limit(1)
            .executeTakeFirst();
    }
    streamForThumbnailJob(force) {
        return this.db
            .selectFrom('assets')
            .select(['assets.id', 'assets.thumbhash'])
            .select(database_2.withFiles)
            .where('assets.deletedAt', 'is', null)
            .where('assets.isVisible', '=', true)
            .$if(!force, (qb) => qb
            .innerJoin('asset_job_status', 'asset_job_status.assetId', 'assets.id')
            .where((eb) => eb.or([
            eb('asset_job_status.previewAt', 'is', null),
            eb('asset_job_status.thumbnailAt', 'is', null),
            eb('assets.thumbhash', 'is', null),
        ])))
            .stream();
    }
    getForMigrationJob(id) {
        return this.db
            .selectFrom('assets')
            .select(['assets.id', 'assets.ownerId', 'assets.encodedVideoPath'])
            .select(database_2.withFiles)
            .where('assets.id', '=', id)
            .executeTakeFirst();
    }
    getForGenerateThumbnailJob(id) {
        return this.db
            .selectFrom('assets')
            .select([
            'assets.id',
            'assets.isVisible',
            'assets.originalFileName',
            'assets.originalPath',
            'assets.ownerId',
            'assets.thumbhash',
            'assets.type',
        ])
            .select(database_2.withFiles)
            .$call(database_2.withExifInner)
            .where('assets.id', '=', id)
            .executeTakeFirst();
    }
    getForMetadataExtraction(id) {
        return this.db
            .selectFrom('assets')
            .select(database_1.columns.asset)
            .select(database_2.withFaces)
            .where('assets.id', '=', id)
            .executeTakeFirst();
    }
    getAlbumThumbnailFiles(id, fileType) {
        return this.db
            .selectFrom('asset_files')
            .select(database_1.columns.assetFiles)
            .where('asset_files.assetId', '=', id)
            .$if(!!fileType, (qb) => qb.where('asset_files.type', '=', fileType))
            .execute();
    }
    getForClipEncoding(id) {
        return this.db
            .selectFrom('assets')
            .select(['assets.id', 'assets.isVisible'])
            .select((eb) => (0, database_2.withFiles)(eb, enum_1.AssetFileType.PREVIEW))
            .where('assets.id', '=', id)
            .executeTakeFirst();
    }
    getForDetectFacesJob(id) {
        return this.db
            .selectFrom('assets')
            .select(['assets.id', 'assets.isVisible'])
            .$call(database_2.withExifInner)
            .select((eb) => (0, database_2.withFaces)(eb, true))
            .select((eb) => (0, database_2.withFiles)(eb, enum_1.AssetFileType.PREVIEW))
            .where('assets.id', '=', id)
            .executeTakeFirst();
    }
    getForSyncAssets(ids) {
        return this.db
            .selectFrom('assets')
            .select([
            'assets.id',
            'assets.isOffline',
            'assets.libraryId',
            'assets.originalPath',
            'assets.status',
            'assets.fileModifiedAt',
        ])
            .where('assets.id', '=', (0, database_2.anyUuid)(ids))
            .execute();
    }
    storageTemplateAssetQuery() {
        return this.db
            .selectFrom('assets')
            .innerJoin('exif', 'assets.id', 'exif.assetId')
            .select([
            'assets.id',
            'assets.ownerId',
            'assets.type',
            'assets.checksum',
            'assets.originalPath',
            'assets.isExternal',
            'assets.sidecarPath',
            'assets.originalFileName',
            'assets.livePhotoVideoId',
            'assets.fileCreatedAt',
            'exif.timeZone',
            'exif.fileSizeInByte',
        ])
            .where('assets.deletedAt', 'is', null);
    }
    getForStorageTemplateJob(id) {
        return this.storageTemplateAssetQuery().where('assets.id', '=', id).executeTakeFirst();
    }
    streamForStorageTemplateJob() {
        return this.storageTemplateAssetQuery().stream();
    }
    streamForDeletedJob(trashedBefore) {
        return this.db
            .selectFrom('assets')
            .select(['id', 'isOffline'])
            .where('assets.deletedAt', '<=', trashedBefore)
            .stream();
    }
};
exports.AssetJobRepository = AssetJobRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSearchDuplicatesJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSidecarWriteJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [false], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForThumbnailJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForMigrationJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForGenerateThumbnailJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForMetadataExtraction", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, enum_1.AssetFileType.THUMBNAIL] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getAlbumThumbnailFiles", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForClipEncoding", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForDetectFacesJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AssetJobRepository.prototype, "getForStorageTemplateJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForStorageTemplateJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.DATE], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Date]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForDeletedJob", null);
exports.AssetJobRepository = AssetJobRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AssetJobRepository);
//# sourceMappingURL=asset-job.repository.js.map