import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { AssetFileType } from 'src/enum';
import { StorageAsset } from 'src/types';
export declare class AssetJobRepository {
    private db;
    constructor(db: Kysely<DB>);
    getForSearchDuplicatesJob(id: string): Promise<{
        id: string;
        type: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            exif: import("src/db").Exif;
            assets: import("src/db").Assets;
            users: import("../schema/tables/user.table").UserTable;
            memories: import("src/db").Memories;
            tags: import("src/db").Tags;
            activity: import("src/db").Activity;
            albums: import("src/db").Albums;
            albums_assets_assets: import("src/db").AlbumsAssetsAssets;
            albums_shared_users_users: import("src/db").AlbumsSharedUsersUsers;
            api_keys: import("src/db").ApiKeys;
            asset_faces: import("src/db").AssetFaces;
            asset_files: import("src/db").AssetFiles;
            asset_job_status: import("src/db").AssetJobStatus;
            asset_stack: import("src/db").AssetStack;
            assets_audit: import("src/db").AssetsAudit;
            audit: import("src/db").Audit;
            face_search: import("src/db").FaceSearch;
            geodata_places: import("src/db").GeodataPlaces;
            libraries: import("src/db").Libraries;
            memories_assets_assets: import("src/db").MemoriesAssetsAssets;
            migrations: import("src/db").Migrations;
            move_history: import("src/db").MoveHistory;
            naturalearth_countries: import("src/db").NaturalearthCountries;
            partners_audit: import("src/db").PartnersAudit;
            partners: import("src/db").Partners;
            person: import("src/db").Person;
            sessions: import("src/db").Sessions;
            session_sync_checkpoints: import("src/db").SessionSyncCheckpoints;
            shared_link__asset: import("src/db").SharedLinkAsset;
            shared_links: import("src/db").SharedLinks;
            smart_search: import("kysely").Nullable<import("src/db").SmartSearch>;
            socket_io_attachments: import("src/db").SocketIoAttachments;
            system_config: import("src/db").SystemConfig;
            system_metadata: import("src/db").SystemMetadata;
            tag_asset: import("src/db").TagAsset;
            tags_closure: import("src/db").TagsClosure;
            typeorm_metadata: import("src/db").TypeormMetadata;
            user_metadata: import("src/db").UserMetadata;
            users_audit: import("src/db").UsersAudit;
            "vectors.pg_vector_index_stat": import("src/db").VectorsPgVectorIndexStat;
            version_history: import("src/db").VersionHistory;
        }, "assets" | "smart_search", "type">;
        ownerId: string;
        duplicateId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            exif: import("src/db").Exif;
            assets: import("src/db").Assets;
            users: import("../schema/tables/user.table").UserTable;
            memories: import("src/db").Memories;
            tags: import("src/db").Tags;
            activity: import("src/db").Activity;
            albums: import("src/db").Albums;
            albums_assets_assets: import("src/db").AlbumsAssetsAssets;
            albums_shared_users_users: import("src/db").AlbumsSharedUsersUsers;
            api_keys: import("src/db").ApiKeys;
            asset_faces: import("src/db").AssetFaces;
            asset_files: import("src/db").AssetFiles;
            asset_job_status: import("src/db").AssetJobStatus;
            asset_stack: import("src/db").AssetStack;
            assets_audit: import("src/db").AssetsAudit;
            audit: import("src/db").Audit;
            face_search: import("src/db").FaceSearch;
            geodata_places: import("src/db").GeodataPlaces;
            libraries: import("src/db").Libraries;
            memories_assets_assets: import("src/db").MemoriesAssetsAssets;
            migrations: import("src/db").Migrations;
            move_history: import("src/db").MoveHistory;
            naturalearth_countries: import("src/db").NaturalearthCountries;
            partners_audit: import("src/db").PartnersAudit;
            partners: import("src/db").Partners;
            person: import("src/db").Person;
            sessions: import("src/db").Sessions;
            session_sync_checkpoints: import("src/db").SessionSyncCheckpoints;
            shared_link__asset: import("src/db").SharedLinkAsset;
            shared_links: import("src/db").SharedLinks;
            smart_search: import("kysely").Nullable<import("src/db").SmartSearch>;
            socket_io_attachments: import("src/db").SocketIoAttachments;
            system_config: import("src/db").SystemConfig;
            system_metadata: import("src/db").SystemMetadata;
            tag_asset: import("src/db").TagAsset;
            tags_closure: import("src/db").TagsClosure;
            typeorm_metadata: import("src/db").TypeormMetadata;
            user_metadata: import("src/db").UserMetadata;
            users_audit: import("src/db").UsersAudit;
            "vectors.pg_vector_index_stat": import("src/db").VectorsPgVectorIndexStat;
            version_history: import("src/db").VersionHistory;
        }, "assets" | "smart_search", "duplicateId">;
        isVisible: boolean;
        stackId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            exif: import("src/db").Exif;
            assets: import("src/db").Assets;
            users: import("../schema/tables/user.table").UserTable;
            memories: import("src/db").Memories;
            tags: import("src/db").Tags;
            activity: import("src/db").Activity;
            albums: import("src/db").Albums;
            albums_assets_assets: import("src/db").AlbumsAssetsAssets;
            albums_shared_users_users: import("src/db").AlbumsSharedUsersUsers;
            api_keys: import("src/db").ApiKeys;
            asset_faces: import("src/db").AssetFaces;
            asset_files: import("src/db").AssetFiles;
            asset_job_status: import("src/db").AssetJobStatus;
            asset_stack: import("src/db").AssetStack;
            assets_audit: import("src/db").AssetsAudit;
            audit: import("src/db").Audit;
            face_search: import("src/db").FaceSearch;
            geodata_places: import("src/db").GeodataPlaces;
            libraries: import("src/db").Libraries;
            memories_assets_assets: import("src/db").MemoriesAssetsAssets;
            migrations: import("src/db").Migrations;
            move_history: import("src/db").MoveHistory;
            naturalearth_countries: import("src/db").NaturalearthCountries;
            partners_audit: import("src/db").PartnersAudit;
            partners: import("src/db").Partners;
            person: import("src/db").Person;
            sessions: import("src/db").Sessions;
            session_sync_checkpoints: import("src/db").SessionSyncCheckpoints;
            shared_link__asset: import("src/db").SharedLinkAsset;
            shared_links: import("src/db").SharedLinks;
            smart_search: import("kysely").Nullable<import("src/db").SmartSearch>;
            socket_io_attachments: import("src/db").SocketIoAttachments;
            system_config: import("src/db").SystemConfig;
            system_metadata: import("src/db").SystemMetadata;
            tag_asset: import("src/db").TagAsset;
            tags_closure: import("src/db").TagsClosure;
            typeorm_metadata: import("src/db").TypeormMetadata;
            user_metadata: import("src/db").UserMetadata;
            users_audit: import("src/db").UsersAudit;
            "vectors.pg_vector_index_stat": import("src/db").VectorsPgVectorIndexStat;
            version_history: import("src/db").VersionHistory;
        }, "assets" | "smart_search", "stackId">;
        embedding: string | null;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    } | undefined>;
    getForSidecarWriteJob(id: string): Promise<{
        id: string;
        originalPath: string;
        sidecarPath: string | null;
        tags: {
            value: string;
        }[];
    } | undefined>;
    streamForThumbnailJob(force: boolean): AsyncIterableIterator<{
        id: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
    } & {
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    } & Partial<Omit<unknown, "id" | "files" | "thumbhash">>>;
    getForMigrationJob(id: string): Promise<{
        id: string;
        ownerId: string;
        encodedVideoPath: string | null;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    } | undefined>;
    getForGenerateThumbnailJob(id: string): Promise<{
        id: string;
        isVisible: boolean;
        originalFileName: string;
        originalPath: string;
        ownerId: string;
        type: import("src/enum").AssetType;
        thumbhash: Buffer<ArrayBufferLike> | null;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
        exifInfo: import("src/database").Exif;
    } | undefined>;
    getForMetadataExtraction(id: string): Promise<{
        id: string;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isExternal: boolean;
        isVisible: boolean;
        libraryId: string | null;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        ownerId: string;
        sidecarPath: string | null;
        type: import("src/enum").AssetType;
        faces: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
        }[];
    } | undefined>;
    getAlbumThumbnailFiles(id: string, fileType?: AssetFileType): Promise<{
        id: string;
        path: string;
        type: AssetFileType;
    }[]>;
    getForClipEncoding(id: string): Promise<{
        id: string;
        isVisible: boolean;
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    } | undefined>;
    getForDetectFacesJob(id: string): Promise<{
        id: string;
        isVisible: boolean;
        exifInfo: import("src/database").Exif;
        faces: {
            id: string;
            assetId: string;
            imageHeight: number;
            imageWidth: number;
            boundingBoxX1: number;
            boundingBoxX2: number;
            boundingBoxY1: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            personId: string | null;
            deletedAt: Date | null;
        }[];
        files: {
            id: string;
            path: string;
            type: AssetFileType;
        }[];
    } | undefined>;
    getForSyncAssets(ids: string[]): Promise<{
        id: string;
        fileModifiedAt: Date;
        libraryId: string | null;
        originalPath: string;
        status: import("src/enum").AssetStatus;
        isOffline: boolean;
    }[]>;
    private storageTemplateAssetQuery;
    getForStorageTemplateJob(id: string): Promise<StorageAsset | undefined>;
    streamForStorageTemplateJob(): AsyncIterableIterator<StorageAsset>;
    streamForDeletedJob(trashedBefore: Date): AsyncIterableIterator<{
        id: string;
        isOffline: boolean;
    }>;
}
