"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const database_2 = require("../utils/database");
let ApiKeyRepository = class ApiKeyRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    create(dto) {
        return this.db.insertInto('api_keys').values(dto).returning(database_1.columns.apiKey).executeTakeFirstOrThrow();
    }
    async update(userId, id, dto) {
        return this.db
            .updateTable('api_keys')
            .set(dto)
            .where('api_keys.userId', '=', userId)
            .where('id', '=', (0, database_2.asUuid)(id))
            .returning(database_1.columns.apiKey)
            .executeTakeFirstOrThrow();
    }
    async delete(userId, id) {
        await this.db.deleteFrom('api_keys').where('userId', '=', userId).where('id', '=', (0, database_2.asUuid)(id)).execute();
    }
    getKey(hashedToken) {
        return this.db
            .selectFrom('api_keys')
            .select((eb) => [
            ...database_1.columns.authApiKey,
            (0, postgres_1.jsonObjectFrom)(eb
                .selectFrom('users')
                .select(database_1.columns.authUser)
                .whereRef('users.id', '=', 'api_keys.userId')
                .where('users.deletedAt', 'is', null)).as('user'),
        ])
            .where('api_keys.key', '=', hashedToken)
            .executeTakeFirst();
    }
    getById(userId, id) {
        return this.db
            .selectFrom('api_keys')
            .select(database_1.columns.apiKey)
            .where('id', '=', (0, database_2.asUuid)(id))
            .where('userId', '=', userId)
            .executeTakeFirst();
    }
    getByUserId(userId) {
        return this.db
            .selectFrom('api_keys')
            .select(database_1.columns.apiKey)
            .where('userId', '=', userId)
            .orderBy('createdAt', 'desc')
            .execute();
    }
};
exports.ApiKeyRepository = ApiKeyRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ApiKeyRepository.prototype, "getKey", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], ApiKeyRepository.prototype, "getById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ApiKeyRepository.prototype, "getByUserId", null);
exports.ApiKeyRepository = ApiKeyRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], ApiKeyRepository);
//# sourceMappingURL=api-key.repository.js.map