import { Insertable, Kysely, Updateable } from 'kysely';
import { ApiKeys, DB } from 'src/db';
export declare class ApiKeyRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(dto: Insertable<ApiKeys>): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        permissions: import("../enum").Permission[];
    }>;
    update(userId: string, id: string, dto: Updateable<ApiKeys>): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        permissions: import("../enum").Permission[];
    }>;
    delete(userId: string, id: string): Promise<void>;
    getKey(hashedToken: string): Promise<{
        id: string;
        permissions: import("../enum").Permission[];
        user: {
            id: string;
            name: string;
            email: string;
            isAdmin: boolean;
            quotaUsageInBytes: number;
            quotaSizeInBytes: number | null;
        } | null;
    } | undefined>;
    getById(userId: string, id: string): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        permissions: import("../enum").Permission[];
    } | undefined>;
    getByUserId(userId: string): Promise<{
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        permissions: import("../enum").Permission[];
    }[]>;
}
