"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const withOwner = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('users').select(database_1.columns.user).whereRef('users.id', '=', 'albums.ownerId'))
        .$notNull()
        .as('owner');
};
const withAlbumUsers = (eb) => {
    return (0, postgres_1.jsonArrayFrom)(eb
        .selectFrom('albums_shared_users_users as album_users')
        .select('album_users.role')
        .select((eb) => (0, postgres_1.jsonObjectFrom)(eb.selectFrom('users').select(database_1.columns.user).whereRef('users.id', '=', 'album_users.usersId'))
        .$notNull()
        .as('user'))
        .whereRef('album_users.albumsId', '=', 'albums.id'))
        .$notNull()
        .as('albumUsers');
};
const withSharedLink = (eb) => {
    return (0, postgres_1.jsonArrayFrom)(eb.selectFrom('shared_links').selectAll().whereRef('shared_links.albumId', '=', 'albums.id')).as('sharedLinks');
};
const withAssets = (eb) => {
    return eb
        .selectFrom((eb) => eb
        .selectFrom('assets')
        .selectAll('assets')
        .leftJoin('exif', 'assets.id', 'exif.assetId')
        .select((eb) => eb.table('exif').$castTo().as('exifInfo'))
        .innerJoin('albums_assets_assets', 'albums_assets_assets.assetsId', 'assets.id')
        .whereRef('albums_assets_assets.albumsId', '=', 'albums.id')
        .where('assets.deletedAt', 'is', null)
        .orderBy('assets.fileCreatedAt', 'desc')
        .as('asset'))
        .select((eb) => eb.fn.jsonAgg('asset').as('assets'))
        .as('assets');
};
let AlbumRepository = class AlbumRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async getById(id, options) {
        return this.db
            .selectFrom('albums')
            .selectAll('albums')
            .where('albums.id', '=', id)
            .where('albums.deletedAt', 'is', null)
            .select(withOwner)
            .select(withAlbumUsers)
            .select(withSharedLink)
            .$if(options.withAssets, (eb) => eb.select(withAssets))
            .$narrowType()
            .executeTakeFirst();
    }
    async getByAssetId(ownerId, assetId) {
        return this.db
            .selectFrom('albums')
            .selectAll('albums')
            .innerJoin('albums_assets_assets as album_assets', 'album_assets.albumsId', 'albums.id')
            .where((eb) => eb.or([
            eb('albums.ownerId', '=', ownerId),
            eb.exists(eb
                .selectFrom('albums_shared_users_users as album_users')
                .whereRef('album_users.albumsId', '=', 'albums.id')
                .where('album_users.usersId', '=', ownerId)),
        ]))
            .where('album_assets.assetsId', '=', assetId)
            .where('albums.deletedAt', 'is', null)
            .orderBy('albums.createdAt', 'desc')
            .select(withOwner)
            .select(withAlbumUsers)
            .orderBy('albums.createdAt', 'desc')
            .execute();
    }
    async getMetadataForIds(ids) {
        if (ids.length === 0) {
            return [];
        }
        return (this.db
            .selectFrom('assets')
            .innerJoin('albums_assets_assets as album_assets', 'album_assets.assetsId', 'assets.id')
            .select('album_assets.albumsId as albumId')
            .select((eb) => eb.fn.min((0, kysely_1.sql) `("assets"."localDateTime" AT TIME ZONE 'UTC'::text)::date`).as('startDate'))
            .select((eb) => eb.fn.max((0, kysely_1.sql) `("assets"."localDateTime" AT TIME ZONE 'UTC'::text)::date`).as('endDate'))
            .select((eb) => eb.fn.max('assets.updatedAt').as('lastModifiedAssetTimestamp'))
            .select((eb) => (0, kysely_1.sql) `${eb.fn.count('assets.id')}::int`.as('assetCount'))
            .where('album_assets.albumsId', 'in', ids)
            .where('assets.deletedAt', 'is', null)
            .groupBy('album_assets.albumsId')
            .execute());
    }
    async getOwned(ownerId) {
        return this.db
            .selectFrom('albums')
            .selectAll('albums')
            .select(withOwner)
            .select(withAlbumUsers)
            .select(withSharedLink)
            .where('albums.ownerId', '=', ownerId)
            .where('albums.deletedAt', 'is', null)
            .orderBy('albums.createdAt', 'desc')
            .execute();
    }
    async getShared(ownerId) {
        return this.db
            .selectFrom('albums')
            .selectAll('albums')
            .where((eb) => eb.or([
            eb.exists(eb
                .selectFrom('albums_shared_users_users as album_users')
                .whereRef('album_users.albumsId', '=', 'albums.id')
                .where((eb) => eb.or([eb('albums.ownerId', '=', ownerId), eb('album_users.usersId', '=', ownerId)]))),
            eb.exists(eb
                .selectFrom('shared_links')
                .whereRef('shared_links.albumId', '=', 'albums.id')
                .where('shared_links.userId', '=', ownerId)),
        ]))
            .where('albums.deletedAt', 'is', null)
            .select(withAlbumUsers)
            .select(withOwner)
            .select(withSharedLink)
            .orderBy('albums.createdAt', 'desc')
            .execute();
    }
    async getNotShared(ownerId) {
        return this.db
            .selectFrom('albums')
            .selectAll('albums')
            .where('albums.ownerId', '=', ownerId)
            .where('albums.deletedAt', 'is', null)
            .where((eb) => eb.not(eb.exists(eb
            .selectFrom('albums_shared_users_users as album_users')
            .whereRef('album_users.albumsId', '=', 'albums.id'))))
            .where((eb) => eb.not(eb.exists(eb.selectFrom('shared_links').whereRef('shared_links.albumId', '=', 'albums.id'))))
            .select(withOwner)
            .orderBy('albums.createdAt', 'desc')
            .execute();
    }
    async restoreAll(userId) {
        await this.db.updateTable('albums').set({ deletedAt: null }).where('ownerId', '=', userId).execute();
    }
    async softDeleteAll(userId) {
        await this.db.updateTable('albums').set({ deletedAt: new Date() }).where('ownerId', '=', userId).execute();
    }
    async deleteAll(userId) {
        await this.db.deleteFrom('albums').where('ownerId', '=', userId).execute();
    }
    async removeAsset(assetId) {
        await this.db.deleteFrom('albums_assets_assets').where('albums_assets_assets.assetsId', '=', assetId).execute();
    }
    async removeAssetIds(albumId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .deleteFrom('albums_assets_assets')
            .where('albums_assets_assets.albumsId', '=', albumId)
            .where('albums_assets_assets.assetsId', 'in', assetIds)
            .execute();
    }
    async getAssetIds(albumId, assetIds) {
        if (assetIds.length === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('albums_assets_assets')
            .selectAll()
            .where('albums_assets_assets.albumsId', '=', albumId)
            .where('albums_assets_assets.assetsId', 'in', assetIds)
            .execute()
            .then((results) => new Set(results.map(({ assetsId }) => assetsId)));
    }
    async addAssetIds(albumId, assetIds) {
        await this.addAssets(this.db, albumId, assetIds);
    }
    create(album, assetIds, albumUsers) {
        return this.db.transaction().execute(async (tx) => {
            const newAlbum = await tx.insertInto('albums').values(album).returning('albums.id').executeTakeFirst();
            if (!newAlbum) {
                throw new Error('Failed to create album');
            }
            if (assetIds.length > 0) {
                await this.addAssets(tx, newAlbum.id, assetIds);
            }
            if (albumUsers.length > 0) {
                await tx
                    .insertInto('albums_shared_users_users')
                    .values(albumUsers.map((albumUser) => ({ albumsId: newAlbum.id, usersId: albumUser.userId, role: albumUser.role })))
                    .execute();
            }
            return tx
                .selectFrom('albums')
                .selectAll()
                .where('id', '=', newAlbum.id)
                .select(withOwner)
                .select(withAssets)
                .select(withAlbumUsers)
                .$narrowType()
                .executeTakeFirstOrThrow();
        });
    }
    update(id, album) {
        return this.db
            .updateTable('albums')
            .set(album)
            .where('id', '=', id)
            .returningAll('albums')
            .returning(withOwner)
            .returning(withSharedLink)
            .returning(withAlbumUsers)
            .executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('albums').where('id', '=', id).execute();
    }
    async addAssets(db, albumId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await db
            .insertInto('albums_assets_assets')
            .values(assetIds.map((assetId) => ({ albumsId: albumId, assetsId: assetId })))
            .execute();
    }
    async updateThumbnails() {
        const result = await this.db
            .updateTable('albums')
            .set((eb) => ({
            albumThumbnailAssetId: this.updateThumbnailBuilder(eb)
                .select('album_assets.assetsId')
                .orderBy('assets.fileCreatedAt', 'desc')
                .limit(1),
        }))
            .where((eb) => eb.or([
            eb.and([
                eb('albumThumbnailAssetId', 'is', null),
                eb.exists(this.updateThumbnailBuilder(eb).select((0, kysely_1.sql) `1`.as('1'))),
            ]),
            eb.and([
                eb('albumThumbnailAssetId', 'is not', null),
                eb.not(eb.exists(this.updateThumbnailBuilder(eb)
                    .select((0, kysely_1.sql) `1`.as('1'))
                    .whereRef('albums.albumThumbnailAssetId', '=', 'album_assets.assetsId'))),
            ]),
        ]))
            .execute();
        return Number(result[0].numUpdatedRows);
    }
    updateThumbnailBuilder(eb) {
        return eb
            .selectFrom('albums_assets_assets as album_assets')
            .innerJoin('assets', (join) => join.onRef('album_assets.assetsId', '=', 'assets.id').on('assets.deletedAt', 'is', null))
            .whereRef('album_assets.albumsId', '=', 'albums.id');
    }
};
exports.AlbumRepository = AlbumRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { withAssets: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getByAssetId", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedArray)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getMetadataForIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getOwned", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getShared", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getNotShared", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "removeAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getAssetIds", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 2, chunkSize: 30_000 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kysely_1.Kysely, String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "addAssets", null);
exports.AlbumRepository = AlbumRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AlbumRepository);
//# sourceMappingURL=album.repository.js.map