import { Insertable, Kysely, Updateable } from 'kysely';
import { Exif } from 'src/database';
import { Albums, DB } from 'src/db';
import { AlbumUserCreateDto } from 'src/dtos/album.dto';
export interface AlbumAssetCount {
    albumId: string;
    assetCount: number;
    startDate: Date | null;
    endDate: Date | null;
    lastModifiedAssetTimestamp: Date | null;
}
export interface AlbumInfoOptions {
    withAssets: boolean;
}
export declare class AlbumRepository {
    private db;
    constructor(db: Kysely<DB>);
    getById(id: string, options: AlbumInfoOptions): Promise<{
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            exifInfo: Exif;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[] | undefined;
        id: string;
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            userId: string;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            albumId: string | null;
            allowDownload: boolean;
            allowUpload: boolean;
            expiresAt: Date | null;
            showExif: boolean;
        }[];
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
    } | undefined>;
    getByAssetId(ownerId: string, assetId: string): Promise<{
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
    }[]>;
    getMetadataForIds(ids: string[]): Promise<AlbumAssetCount[]>;
    getOwned(ownerId: string): Promise<{
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            userId: string;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            albumId: string | null;
            allowDownload: boolean;
            allowUpload: boolean;
            expiresAt: Date | null;
            showExif: boolean;
        }[];
    }[]>;
    getShared(ownerId: string): Promise<{
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            userId: string;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            albumId: string | null;
            allowDownload: boolean;
            allowUpload: boolean;
            expiresAt: Date | null;
            showExif: boolean;
        }[];
    }[]>;
    getNotShared(ownerId: string): Promise<{
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
    }[]>;
    restoreAll(userId: string): Promise<void>;
    softDeleteAll(userId: string): Promise<void>;
    deleteAll(userId: string): Promise<void>;
    removeAsset(assetId: string): Promise<void>;
    removeAssetIds(albumId: string, assetIds: string[]): Promise<void>;
    getAssetIds(albumId: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(albumId: string, assetIds: string[]): Promise<void>;
    create(album: Insertable<Albums>, assetIds: string[], albumUsers: AlbumUserCreateDto[]): Promise<{
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            exifInfo: Exif;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
    }>;
    update(id: string, album: Updateable<Albums>): Promise<{
        id: string;
        description: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updateId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            createdAt: Date;
            userId: string;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            albumId: string | null;
            allowDownload: boolean;
            allowUpload: boolean;
            expiresAt: Date | null;
            showExif: boolean;
        }[];
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                name: string;
                id: string;
                email: string;
                profileImagePath: string;
                profileChangedAt: Date;
            };
        }[];
    }>;
    delete(id: string): Promise<void>;
    private addAssets;
    updateThumbnails(): Promise<number | undefined>;
    private updateThumbnailBuilder;
}
