import { Insertable, Kysely, Selectable, Updateable } from 'kysely';
import { AlbumsSharedUsersUsers, DB } from 'src/db';
import { AlbumUserRole } from 'src/enum';
export type AlbumPermissionId = {
    albumsId: string;
    usersId: string;
};
export declare class AlbumUserRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(albumUser: Insertable<AlbumsSharedUsersUsers>): Promise<Selectable<AlbumsSharedUsersUsers>>;
    update({ usersId, albumsId }: AlbumPermissionId, dto: Updateable<AlbumsSharedUsersUsers>): Promise<{
        albumsId: string;
        role: AlbumUserRole;
        usersId: string;
    }>;
    delete({ usersId, albumsId }: AlbumPermissionId): Promise<void>;
}
