import { Insertable, Kysely } from 'kysely';
import { Activity, DB } from 'src/db';
export interface ActivitySearch {
    albumId?: string;
    assetId?: string | null;
    userId?: string;
    isLiked?: boolean;
}
export declare class ActivityRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(options: ActivitySearch): Promise<{
        id: string;
        assetId: string | null;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        comment: string | null;
        albumId: string;
        isLiked: boolean;
        user: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
    }[]>;
    create(activity: Insertable<Activity>): Promise<{
        id: string;
        user: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        assetId: string | null;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        comment: string | null;
        albumId: string;
        isLiked: boolean;
    }>;
    delete(id: string): Promise<void>;
    getStatistics({ albumId, assetId }: {
        albumId: string;
        assetId?: string;
    }): Promise<number>;
}
