"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
class ActivityAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, activityIds) {
        if (activityIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('activity')
            .select('activity.id')
            .where('activity.id', 'in', [...activityIds])
            .where('activity.userId', '=', userId)
            .execute()
            .then((activities) => new Set(activities.map((activity) => activity.id)));
    }
    async checkAlbumOwnerAccess(userId, activityIds) {
        if (activityIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('activity')
            .select('activity.id')
            .leftJoin('albums', (join) => join.onRef('activity.albumId', '=', 'albums.id').on('albums.deletedAt', 'is', null))
            .where('activity.id', 'in', [...activityIds])
            .whereRef('albums.ownerId', '=', (0, database_1.asUuid)(userId))
            .execute()
            .then((activities) => new Set(activities.map((activity) => activity.id)));
    }
    async checkCreateAccess(userId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('albums')
            .select('albums.id')
            .leftJoin('albums_shared_users_users as albumUsers', 'albumUsers.albumsId', 'albums.id')
            .leftJoin('users', (join) => join.onRef('users.id', '=', 'albumUsers.usersId').on('users.deletedAt', 'is', null))
            .where('albums.id', 'in', [...albumIds])
            .where('albums.isActivityEnabled', '=', true)
            .where((eb) => eb.or([eb('albums.ownerId', '=', userId), eb('users.id', '=', userId)]))
            .where('albums.deletedAt', 'is', null)
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkAlbumOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkCreateAccess", null);
class AlbumAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('albums')
            .select('albums.id')
            .where('albums.id', 'in', [...albumIds])
            .where('albums.ownerId', '=', userId)
            .where('albums.deletedAt', 'is', null)
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
    async checkSharedAlbumAccess(userId, albumIds, access) {
        if (albumIds.size === 0) {
            return new Set();
        }
        const accessRole = access === enum_1.AlbumUserRole.EDITOR ? [enum_1.AlbumUserRole.EDITOR] : [enum_1.AlbumUserRole.EDITOR, enum_1.AlbumUserRole.VIEWER];
        return this.db
            .selectFrom('albums')
            .select('albums.id')
            .leftJoin('albums_shared_users_users as albumUsers', 'albumUsers.albumsId', 'albums.id')
            .leftJoin('users', (join) => join.onRef('users.id', '=', 'albumUsers.usersId').on('users.deletedAt', 'is', null))
            .where('albums.id', 'in', [...albumIds])
            .where('albums.deletedAt', 'is', null)
            .where('users.id', '=', userId)
            .where('albumUsers.role', 'in', [...accessRole])
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
    async checkSharedLinkAccess(sharedLinkId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('shared_links')
            .select('shared_links.albumId')
            .where('shared_links.id', '=', sharedLinkId)
            .where('shared_links.albumId', 'in', [...albumIds])
            .execute()
            .then((sharedLinks) => new Set(sharedLinks.flatMap((sharedLink) => (sharedLink.albumId ? [sharedLink.albumId] : []))));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set, String]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkSharedAlbumAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkSharedLinkAccess", null);
class AssetAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkAlbumAccess(userId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('albums')
            .innerJoin('albums_assets_assets as albumAssets', 'albums.id', 'albumAssets.albumsId')
            .innerJoin('assets', (join) => join.onRef('assets.id', '=', 'albumAssets.assetsId').on('assets.deletedAt', 'is', null))
            .leftJoin('albums_shared_users_users as albumUsers', 'albumUsers.albumsId', 'albums.id')
            .leftJoin('users', (join) => join.onRef('users.id', '=', 'albumUsers.usersId').on('users.deletedAt', 'is', null))
            .select(['assets.id', 'assets.livePhotoVideoId'])
            .where((0, kysely_1.sql) `array["assets"."id", "assets"."livePhotoVideoId"]`, '&&', (0, kysely_1.sql) `array[${kysely_1.sql.join([...assetIds])}]::uuid[] `)
            .where((eb) => eb.or([eb('albums.ownerId', '=', userId), eb('users.id', '=', userId)]))
            .where('albums.deletedAt', 'is', null)
            .execute()
            .then((assets) => {
            const allowedIds = new Set();
            for (const asset of assets) {
                if (asset.id && assetIds.has(asset.id)) {
                    allowedIds.add(asset.id);
                }
                if (asset.livePhotoVideoId && assetIds.has(asset.livePhotoVideoId)) {
                    allowedIds.add(asset.livePhotoVideoId);
                }
            }
            return allowedIds;
        });
    }
    async checkOwnerAccess(userId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('assets')
            .select('assets.id')
            .where('assets.id', 'in', [...assetIds])
            .where('assets.ownerId', '=', userId)
            .execute()
            .then((assets) => new Set(assets.map((asset) => asset.id)));
    }
    async checkPartnerAccess(userId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partners as partner')
            .innerJoin('users as sharedBy', (join) => join.onRef('sharedBy.id', '=', 'partner.sharedById').on('sharedBy.deletedAt', 'is', null))
            .innerJoin('assets', (join) => join.onRef('assets.ownerId', '=', 'sharedBy.id').on('assets.deletedAt', 'is', null))
            .select('assets.id')
            .where('partner.sharedWithId', '=', userId)
            .where('assets.isArchived', '=', false)
            .where('assets.id', 'in', [...assetIds])
            .execute()
            .then((assets) => new Set(assets.map((asset) => asset.id)));
    }
    async checkSharedLinkAccess(sharedLinkId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('shared_links')
            .leftJoin('albums', (join) => join.onRef('albums.id', '=', 'shared_links.albumId').on('albums.deletedAt', 'is', null))
            .leftJoin('shared_link__asset', 'shared_link__asset.sharedLinksId', 'shared_links.id')
            .leftJoin('assets', (join) => join.onRef('assets.id', '=', 'shared_link__asset.assetsId').on('assets.deletedAt', 'is', null))
            .leftJoin('albums_assets_assets', 'albums_assets_assets.albumsId', 'albums.id')
            .leftJoin('assets as albumAssets', (join) => join.onRef('albumAssets.id', '=', 'albums_assets_assets.assetsId').on('albumAssets.deletedAt', 'is', null))
            .select([
            'assets.id as assetId',
            'assets.livePhotoVideoId as assetLivePhotoVideoId',
            'albumAssets.id as albumAssetId',
            'albumAssets.livePhotoVideoId as albumAssetLivePhotoVideoId',
        ])
            .where('shared_links.id', '=', sharedLinkId)
            .where((0, kysely_1.sql) `array["assets"."id", "assets"."livePhotoVideoId", "albumAssets"."id", "albumAssets"."livePhotoVideoId"]`, '&&', (0, kysely_1.sql) `array[${kysely_1.sql.join([...assetIds])}]::uuid[] `)
            .execute()
            .then((rows) => {
            const allowedIds = new Set();
            for (const row of rows) {
                if (row.assetId && assetIds.has(row.assetId)) {
                    allowedIds.add(row.assetId);
                }
                if (row.assetLivePhotoVideoId && assetIds.has(row.assetLivePhotoVideoId)) {
                    allowedIds.add(row.assetLivePhotoVideoId);
                }
                if (row.albumAssetId && assetIds.has(row.albumAssetId)) {
                    allowedIds.add(row.albumAssetId);
                }
                if (row.albumAssetLivePhotoVideoId && assetIds.has(row.albumAssetLivePhotoVideoId)) {
                    allowedIds.add(row.albumAssetLivePhotoVideoId);
                }
            }
            return allowedIds;
        });
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkAlbumAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkPartnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkSharedLinkAccess", null);
class AuthDeviceAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, deviceIds) {
        if (deviceIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('sessions')
            .select('sessions.id')
            .where('sessions.userId', '=', userId)
            .where('sessions.id', 'in', [...deviceIds])
            .execute()
            .then((tokens) => new Set(tokens.map((token) => token.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AuthDeviceAccess.prototype, "checkOwnerAccess", null);
class StackAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, stackIds) {
        if (stackIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('asset_stack as stacks')
            .select('stacks.id')
            .where('stacks.id', 'in', [...stackIds])
            .where('stacks.ownerId', '=', userId)
            .execute()
            .then((stacks) => new Set(stacks.map((stack) => stack.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], StackAccess.prototype, "checkOwnerAccess", null);
class TimelineAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkPartnerAccess(userId, partnerIds) {
        if (partnerIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partners')
            .select('partners.sharedById')
            .where('partners.sharedById', 'in', [...partnerIds])
            .where('partners.sharedWithId', '=', userId)
            .execute()
            .then((partners) => new Set(partners.map((partner) => partner.sharedById)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], TimelineAccess.prototype, "checkPartnerAccess", null);
class MemoryAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, memoryIds) {
        if (memoryIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('memories')
            .select('memories.id')
            .where('memories.id', 'in', [...memoryIds])
            .where('memories.ownerId', '=', userId)
            .where('memories.deletedAt', 'is', null)
            .execute()
            .then((memories) => new Set(memories.map((memory) => memory.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], MemoryAccess.prototype, "checkOwnerAccess", null);
class PersonAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, personIds) {
        if (personIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('person')
            .select('person.id')
            .where('person.id', 'in', [...personIds])
            .where('person.ownerId', '=', userId)
            .execute()
            .then((persons) => new Set(persons.map((person) => person.id)));
    }
    async checkFaceOwnerAccess(userId, assetFaceIds) {
        if (assetFaceIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('asset_faces')
            .select('asset_faces.id')
            .leftJoin('assets', (join) => join.onRef('assets.id', '=', 'asset_faces.assetId').on('assets.deletedAt', 'is', null))
            .where('asset_faces.id', 'in', [...assetFaceIds])
            .where('assets.ownerId', '=', userId)
            .execute()
            .then((faces) => new Set(faces.map((face) => face.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PersonAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PersonAccess.prototype, "checkFaceOwnerAccess", null);
class PartnerAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkUpdateAccess(userId, partnerIds) {
        if (partnerIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partners')
            .select('partners.sharedById')
            .where('partners.sharedById', 'in', [...partnerIds])
            .where('partners.sharedWithId', '=', userId)
            .execute()
            .then((partners) => new Set(partners.map((partner) => partner.sharedById)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PartnerAccess.prototype, "checkUpdateAccess", null);
class TagAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, tagIds) {
        if (tagIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('tags')
            .select('tags.id')
            .where('tags.id', 'in', [...tagIds])
            .where('tags.userId', '=', userId)
            .execute()
            .then((tags) => new Set(tags.map((tag) => tag.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], TagAccess.prototype, "checkOwnerAccess", null);
let AccessRepository = class AccessRepository {
    activity;
    album;
    asset;
    authDevice;
    memory;
    person;
    partner;
    stack;
    tag;
    timeline;
    constructor(db) {
        this.activity = new ActivityAccess(db);
        this.album = new AlbumAccess(db);
        this.asset = new AssetAccess(db);
        this.authDevice = new AuthDeviceAccess(db);
        this.memory = new MemoryAccess(db);
        this.person = new PersonAccess(db);
        this.partner = new PartnerAccess(db);
        this.stack = new StackAccess(db);
        this.tag = new TagAccess(db);
        this.timeline = new TimelineAccess(db);
    }
};
exports.AccessRepository = AccessRepository;
exports.AccessRepository = AccessRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AccessRepository);
//# sourceMappingURL=access.repository.js.map