import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { AlbumUserRole } from 'src/enum';
declare class ActivityAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, activityIds: Set<string>): Promise<Set<string>>;
    checkAlbumOwnerAccess(userId: string, activityIds: Set<string>): Promise<Set<string>>;
    checkCreateAccess(userId: string, albumIds: Set<string>): Promise<Set<string>>;
}
declare class AlbumAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, albumIds: Set<string>): Promise<Set<string>>;
    checkSharedAlbumAccess(userId: string, albumIds: Set<string>, access: AlbumUserRole): Promise<Set<string>>;
    checkSharedLinkAccess(sharedLinkId: string, albumIds: Set<string>): Promise<Set<string>>;
}
declare class AssetAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkAlbumAccess(userId: string, assetIds: Set<string>): Promise<Set<string>>;
    checkOwnerAccess(userId: string, assetIds: Set<string>): Promise<Set<string>>;
    checkPartnerAccess(userId: string, assetIds: Set<string>): Promise<Set<string>>;
    checkSharedLinkAccess(sharedLinkId: string, assetIds: Set<string>): Promise<Set<string>>;
}
declare class AuthDeviceAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, deviceIds: Set<string>): Promise<Set<string>>;
}
declare class StackAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, stackIds: Set<string>): Promise<Set<string>>;
}
declare class TimelineAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkPartnerAccess(userId: string, partnerIds: Set<string>): Promise<Set<string>>;
}
declare class MemoryAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, memoryIds: Set<string>): Promise<Set<string>>;
}
declare class PersonAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, personIds: Set<string>): Promise<Set<string>>;
    checkFaceOwnerAccess(userId: string, assetFaceIds: Set<string>): Promise<Set<string>>;
}
declare class PartnerAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkUpdateAccess(userId: string, partnerIds: Set<string>): Promise<Set<string>>;
}
declare class TagAccess {
    private db;
    constructor(db: Kysely<DB>);
    checkOwnerAccess(userId: string, tagIds: Set<string>): Promise<Set<string>>;
}
export declare class AccessRepository {
    activity: ActivityAccess;
    album: AlbumAccess;
    asset: AssetAccess;
    authDevice: AuthDeviceAccess;
    memory: MemoryAccess;
    person: PersonAccess;
    partner: PartnerAccess;
    stack: StackAccess;
    tag: TagAccess;
    timeline: TimelineAccess;
    constructor(db: Kysely<DB>);
}
export {};
