"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FixAssetAndUserCascadeConditions1741280328985 = void 0;
class FixAssetAndUserCascadeConditions1741280328985 {
    name = 'FixAssetAndUserCascadeConditions1741280328985';
    async up(queryRunner) {
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER assets_delete_audit
      AFTER DELETE ON assets
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      WHEN (pg_trigger_depth() = 0)
      EXECUTE FUNCTION assets_delete_audit();`);
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER users_delete_audit
      AFTER DELETE ON users
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      WHEN (pg_trigger_depth() = 0)
      EXECUTE FUNCTION users_delete_audit();`);
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER partners_delete_audit
      AFTER DELETE ON partners
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      WHEN (pg_trigger_depth() = 0)
      EXECUTE FUNCTION partners_delete_audit();`);
    }
    async down(queryRunner) {
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER assets_delete_audit
      AFTER DELETE ON assets
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      EXECUTE FUNCTION assets_delete_audit();`);
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER users_delete_audit
      AFTER DELETE ON users
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      EXECUTE FUNCTION users_delete_audit();`);
        await queryRunner.query(`
      CREATE OR REPLACE TRIGGER partners_delete_audit
      AFTER DELETE ON partners
      REFERENCING OLD TABLE AS OLD
      FOR EACH STATEMENT
      EXECUTE FUNCTION partners_delete_audit();`);
    }
}
exports.FixAssetAndUserCascadeConditions1741280328985 = FixAssetAndUserCascadeConditions1741280328985;
//# sourceMappingURL=1741280328985-FixAssetAndUserCascadeConditions.js.map