"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddManualSourceType1740619600996 = void 0;
class AddManualSourceType1740619600996 {
    async up(queryRunner) {
        await queryRunner.query(`ALTER TYPE sourceType ADD VALUE 'manual'`);
    }
    async down(queryRunner) {
        await queryRunner.query(`UPDATE "asset_faces" SET "sourceType" = 'machine-learning' WHERE "sourceType" = 'manual';`);
        await queryRunner.query(`ALTER TYPE sourceType RENAME TO oldSourceType`);
        await queryRunner.query(`CREATE TYPE sourceType AS ENUM ('machine-learning', 'exif');`);
        await queryRunner.query(`ALTER TABLE "asset_faces" ALTER COLUMN "sourceType" DROP DEFAULT;`);
        await queryRunner.query(`ALTER TABLE "asset_faces" ALTER COLUMN "sourceType" TYPE sourceType USING "sourceType"::text::sourceType;`);
        await queryRunner.query(`ALTER TABLE "asset_faces" ALTER COLUMN "sourceType" SET DEFAULT 'machine-learning'::sourceType;`);
        await queryRunner.query(`DROP TYPE oldSourceType;`);
    }
}
exports.AddManualSourceType1740619600996 = AddManualSourceType1740619600996;
//# sourceMappingURL=1740619600996-AddManualSourceType.js.map