"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddTimeBucketIndices1734574016301 = void 0;
class AddTimeBucketIndices1734574016301 {
    async up(queryRunner) {
        await queryRunner.query(`CREATE INDEX idx_local_date_time_month ON assets ((date_trunc('MONTH', "localDateTime" at time zone 'UTC') at time zone 'UTC'))`);
        await queryRunner.query(`CREATE INDEX idx_local_date_time ON assets ((("localDateTime" at time zone 'UTC')::date))`);
        await queryRunner.query(`DROP INDEX "IDX_day_of_month"`);
        await queryRunner.query(`DROP INDEX "IDX_month"`);
    }
    async down(queryRunner) {
        await queryRunner.query(`DROP INDEX idx_local_date_time_month`);
        await queryRunner.query(`DROP INDEX idx_local_date_time`);
        await queryRunner.query(`CREATE INDEX "IDX_day_of_month" ON assets (EXTRACT(DAY FROM "localDateTime" AT TIME ZONE 'UTC'))`);
        await queryRunner.query(`CREATE INDEX "IDX_month" ON assets (EXTRACT(MONTH FROM "localDateTime" AT TIME ZONE 'UTC'))`);
    }
}
exports.AddTimeBucketIndices1734574016301 = AddTimeBucketIndices1734574016301;
//# sourceMappingURL=1734574016301-AddTimeBucketIndices.js.map