"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveSystemConfigTable1715787369686 = void 0;
const lodash_1 = __importDefault(require("lodash"));
class RemoveSystemConfigTable1715787369686 {
    async up(queryRunner) {
        const overrides = await queryRunner.query('SELECT "key", "value" FROM "system_config"');
        if (overrides.length === 0) {
            return;
        }
        const config = {};
        for (const { key, value } of overrides) {
            lodash_1.default.set(config, key, JSON.parse(value));
        }
        await queryRunner.query(`INSERT INTO "system_metadata" ("key", "value") VALUES ($1, $2)`, [
            'system-config',
            JSON.stringify(JSON.stringify(config)),
        ]);
        await queryRunner.query(`DROP TABLE "system_config"`);
    }
    async down(queryRunner) {
        await queryRunner.query(`CREATE TABLE "system_config" ("key" character varying NOT NULL, "value" character varying, CONSTRAINT "PK_aab69295b445016f56731f4d535" PRIMARY KEY ("key"))`);
    }
}
exports.RemoveSystemConfigTable1715787369686 = RemoveSystemConfigTable1715787369686;
//# sourceMappingURL=1715787369686-RemoveSystemConfigTable.js.map