"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddFaceEmbeddingIndex1700714033632 = void 0;
const enum_1 = require("../enum");
const config_repository_1 = require("../repositories/config.repository");
const vectorExtension = new config_repository_1.ConfigRepository().getEnv().database.vectorExtension;
class AddFaceEmbeddingIndex1700714033632 {
    name = 'AddFaceEmbeddingIndex1700714033632';
    async up(queryRunner) {
        if (vectorExtension === enum_1.DatabaseExtension.VECTORS) {
            await queryRunner.query(`SET vectors.pgvector_compatibility=on`);
        }
        await queryRunner.query(`SET search_path TO "$user", public, vectors`);
        await queryRunner.query(`
      CREATE INDEX IF NOT EXISTS face_index ON asset_faces
      USING hnsw (embedding vector_cosine_ops)
      WITH (ef_construction = 300, m = 16)`);
    }
    async down(queryRunner) {
        await queryRunner.query(`DROP INDEX IF EXISTS face_index`);
    }
}
exports.AddFaceEmbeddingIndex1700714033632 = AddFaceEmbeddingIndex1700714033632;
//# sourceMappingURL=1700714033632-AddFaceEmbeddingIndex.js.map