"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddCLIPEmbeddingIndex1700713994428 = void 0;
const enum_1 = require("../enum");
const config_repository_1 = require("../repositories/config.repository");
const vectorExtension = new config_repository_1.ConfigRepository().getEnv().database.vectorExtension;
class AddCLIPEmbeddingIndex1700713994428 {
    name = 'AddCLIPEmbeddingIndex1700713994428';
    async up(queryRunner) {
        if (vectorExtension === enum_1.DatabaseExtension.VECTORS) {
            await queryRunner.query(`SET vectors.pgvector_compatibility=on`);
        }
        await queryRunner.query(`SET search_path TO "$user", public, vectors`);
        await queryRunner.query(`
      CREATE INDEX IF NOT EXISTS clip_index ON smart_search
      USING hnsw (embedding vector_cosine_ops)
      WITH (ef_construction = 300, m = 16)`);
    }
    async down(queryRunner) {
        await queryRunner.query(`DROP INDEX IF EXISTS clip_index`);
    }
}
exports.AddCLIPEmbeddingIndex1700713994428 = AddCLIPEmbeddingIndex1700713994428;
//# sourceMappingURL=1700713994428-AddCLIPEmbeddingIndex.js.map