"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumThumbnailRelation1677613712565 = void 0;
class AlbumThumbnailRelation1677613712565 {
    name = 'AlbumThumbnailRelation1677613712565';
    async up(queryRunner) {
        await queryRunner.query(`
      UPDATE "albums"
      SET
        "albumThumbnailAssetId" = (
            SELECT
              "albums_assets2"."assetsId"
            FROM
              "assets" "assets",
              "albums_assets_assets" "albums_assets2"
            WHERE
                "albums_assets2"."assetsId" = "assets"."id"
                AND "albums_assets2"."albumsId" = "albums"."id"
            ORDER BY
              "assets"."fileCreatedAt" DESC
            LIMIT 1
        ),
        "updatedAt" = CURRENT_TIMESTAMP
      WHERE
        "albums"."albumThumbnailAssetId" IS NULL
        AND EXISTS (
            SELECT 1
            FROM "albums_assets_assets" "albums_assets"
            WHERE "albums"."id" = "albums_assets"."albumsId"
        )
        OR "albums"."albumThumbnailAssetId" IS NOT NULL
        AND NOT EXISTS (
          SELECT 1
          FROM "albums_assets_assets" "albums_assets"
          WHERE
            "albums"."id" = "albums_assets"."albumsId"
            AND "albums"."albumThumbnailAssetId" = "albums_assets"."assetsId"::varchar
      )
    `);
        await queryRunner.query(`
      ALTER TABLE "albums"
      ALTER COLUMN "albumThumbnailAssetId"
      TYPE uuid USING "albumThumbnailAssetId"::uuid
    `);
        await queryRunner.query(`
      ALTER TABLE "albums" ADD CONSTRAINT "FK_05895aa505a670300d4816debce" FOREIGN KEY ("albumThumbnailAssetId") REFERENCES "assets"("id") ON DELETE SET NULL ON UPDATE CASCADE
    `);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE "albums" DROP CONSTRAINT "FK_05895aa505a670300d4816debce"`);
        await queryRunner.query(`
      ALTER TABLE "albums" ALTER COLUMN "albumThumbnailAssetId" TYPE varchar USING "albumThumbnailAssetId"::varchar
    `);
    }
}
exports.AlbumThumbnailRelation1677613712565 = AlbumThumbnailRelation1677613712565;
//# sourceMappingURL=1677613712565-AlbumThumbnailRelation.js.map