"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddLocationToExifTextSearch1646710459852 = void 0;
class AddLocationToExifTextSearch1646710459852 {
    async up(queryRunner) {
        await queryRunner.query(`
      ALTER TABLE exif 
      DROP COLUMN IF EXISTS exif_text_searchable_column;

      ALTER TABLE exif
      ADD COLUMN IF NOT EXISTS exif_text_searchable_column tsvector
          GENERATED ALWAYS AS (
              TO_TSVECTOR('english',
                         COALESCE(make, '') || ' ' ||
                         COALESCE(model, '') || ' ' ||
                         COALESCE(orientation, '') || ' ' ||
                         COALESCE("lensModel", '') || ' ' ||
                         COALESCE("city", '') || ' ' ||
                         COALESCE("state", '') || ' ' ||
                         COALESCE("country", '')
                  )
              ) STORED;

      CREATE INDEX exif_text_searchable_idx 
        ON exif 
        USING GIN (exif_text_searchable_column);
    `);
    }
    async down(queryRunner) {
        await queryRunner.query(`
      ALTER TABLE exif 
      DROP COLUMN IF EXISTS exif_text_searchable_column;

      DROP INDEX IF EXISTS exif_text_searchable_idx ON exif;
      `);
    }
}
exports.AddLocationToExifTextSearch1646710459852 = AddLocationToExifTextSearch1646710459852;
//# sourceMappingURL=1646710459852-AddLocationToExifTextSearch.js.map