"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAssetsTable1645130805273 = void 0;
class CreateAssetsTable1645130805273 {
    async up(queryRunner) {
        await queryRunner.query(`
        create table if not exists assets
        (
            id              uuid    default uuid_generate_v4() not null
                constraint "PK_da96729a8b113377cfb6a62439c"
                    primary key,
            "deviceAssetId" varchar                            not null,
            "userId"        varchar                            not null,
            "deviceId"      varchar                            not null,
            type            varchar                            not null,
            "originalPath"  varchar                            not null,
            "resizePath"    varchar,
            "createdAt"     varchar                            not null,
            "modifiedAt"    varchar                            not null,
            "isFavorite"    boolean default false              not null,
            "mimeType"      varchar,
            duration        varchar,
            constraint "UQ_b599ab0bd9574958acb0b30a90e"
                unique ("deviceAssetId", "userId", "deviceId")
        );
      `);
    }
    async down(queryRunner) {
        await queryRunner.query(`drop table assets`);
    }
}
exports.CreateAssetsTable1645130805273 = CreateAssetsTable1645130805273;
//# sourceMappingURL=1645130805273-CreateAssetsTable.js.map