"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var FileUploadInterceptor_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileUploadInterceptor = void 0;
exports.getFile = getFile;
exports.getFiles = getFiles;
const common_1 = require("@nestjs/common");
const constants_1 = require("@nestjs/common/constants");
const core_1 = require("@nestjs/core");
const multer_utils_1 = require("@nestjs/platform-express/multer/multer/multer.utils");
const multer_1 = __importStar(require("multer"));
const node_crypto_1 = require("node:crypto");
const asset_media_dto_1 = require("../dtos/asset-media.dto");
const enum_1 = require("../enum");
const logging_repository_1 = require("../repositories/logging.repository");
const asset_media_service_1 = require("../services/asset-media.service");
const asset_util_1 = require("../utils/asset.util");
function getFile(files, property) {
    const file = files[property]?.[0];
    return file ? (0, asset_util_1.mapToUploadFile)(file) : file;
}
function getFiles(files) {
    return {
        file: getFile(files, 'assetData'),
        sidecarFile: getFile(files, 'sidecarData'),
    };
}
const callbackify = (target, callback) => {
    try {
        return callback(null, target());
    }
    catch (error) {
        return callback(error);
    }
};
let FileUploadInterceptor = FileUploadInterceptor_1 = class FileUploadInterceptor {
    reflect;
    assetService;
    logger;
    handlers;
    defaultStorage;
    constructor(reflect, assetService, logger) {
        this.reflect = reflect;
        this.assetService = assetService;
        this.logger = logger;
        this.logger.setContext(FileUploadInterceptor_1.name);
        this.defaultStorage = (0, multer_1.diskStorage)({
            filename: this.filename.bind(this),
            destination: this.destination.bind(this),
        });
        const instance = (0, multer_1.default)({
            fileFilter: this.fileFilter.bind(this),
            storage: {
                _handleFile: this.handleFile.bind(this),
                _removeFile: this.removeFile.bind(this),
            },
        });
        this.handlers = {
            userProfile: instance.single(asset_media_dto_1.UploadFieldName.PROFILE_DATA),
            assetUpload: instance.fields([
                { name: asset_media_dto_1.UploadFieldName.ASSET_DATA, maxCount: 1 },
                { name: asset_media_dto_1.UploadFieldName.SIDECAR_DATA, maxCount: 1 },
            ]),
        };
    }
    async intercept(context, next) {
        const context_ = context.switchToHttp();
        const route = this.reflect.get(constants_1.PATH_METADATA, context.getClass());
        const handler = this.getHandler(route);
        if (handler) {
            await new Promise((resolve, reject) => {
                const next = (error) => (error ? reject((0, multer_utils_1.transformException)(error)) : resolve());
                handler(context_.getRequest(), context_.getResponse(), next);
            });
        }
        else {
            this.logger.warn(`Skipping invalid file upload route: ${route}`);
        }
        return next.handle();
    }
    fileFilter(request, file, callback) {
        return callbackify(() => this.assetService.canUploadFile((0, asset_util_1.asRequest)(request, file)), callback);
    }
    filename(request, file, callback) {
        return callbackify(() => this.assetService.getUploadFilename((0, asset_util_1.asRequest)(request, file)), callback);
    }
    destination(request, file, callback) {
        return callbackify(() => this.assetService.getUploadFolder((0, asset_util_1.asRequest)(request, file)), callback);
    }
    handleFile(request, file, callback) {
        file.uuid = (0, node_crypto_1.randomUUID)();
        request.on('error', (error) => {
            this.logger.warn('Request error while uploading file, cleaning up', error);
            this.assetService.onUploadError(request, file).catch(this.logger.error);
        });
        if (!this.isAssetUploadFile(file)) {
            this.defaultStorage._handleFile(request, file, callback);
            return;
        }
        const hash = (0, node_crypto_1.createHash)('sha1');
        file.stream.on('data', (chunk) => hash.update(chunk));
        this.defaultStorage._handleFile(request, file, (error, info) => {
            if (error) {
                hash.destroy();
                callback(error);
            }
            else {
                callback(null, { ...info, checksum: hash.digest() });
            }
        });
    }
    removeFile(request, file, callback) {
        this.defaultStorage._removeFile(request, file, callback);
    }
    isAssetUploadFile(file) {
        switch (file.fieldname) {
            case asset_media_dto_1.UploadFieldName.ASSET_DATA: {
                return true;
            }
        }
        return false;
    }
    getHandler(route) {
        switch (route) {
            case enum_1.RouteKey.ASSET: {
                return this.handlers.assetUpload;
            }
            case enum_1.RouteKey.USER: {
                return this.handlers.userProfile;
            }
            default: {
                return null;
            }
        }
    }
};
exports.FileUploadInterceptor = FileUploadInterceptor;
exports.FileUploadInterceptor = FileUploadInterceptor = FileUploadInterceptor_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector,
        asset_media_service_1.AssetMediaService,
        logging_repository_1.LoggingRepository])
], FileUploadInterceptor);
//# sourceMappingURL=file-upload.interceptor.js.map