"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AuthGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthGuard = exports.GetLoginDetails = exports.FileResponse = exports.Auth = exports.Authenticated = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const enum_1 = require("../enum");
const logging_repository_1 = require("../repositories/logging.repository");
const auth_service_1 = require("../services/auth.service");
const ua_parser_js_1 = require("ua-parser-js");
const Authenticated = (options) => {
    const decorators = [
        (0, swagger_1.ApiBearerAuth)(),
        (0, swagger_1.ApiCookieAuth)(),
        (0, swagger_1.ApiSecurity)(enum_1.MetadataKey.API_KEY_SECURITY),
        (0, common_1.SetMetadata)(enum_1.MetadataKey.AUTH_ROUTE, options || {}),
    ];
    if (options?.sharedLink) {
        decorators.push((0, swagger_1.ApiQuery)({ name: enum_1.ImmichQuery.SHARED_LINK_KEY, type: String, required: false }));
    }
    return (0, common_1.applyDecorators)(...decorators);
};
exports.Authenticated = Authenticated;
exports.Auth = (0, common_1.createParamDecorator)((data, context) => {
    return context.switchToHttp().getRequest().user;
});
const FileResponse = () => (0, swagger_1.ApiOkResponse)({
    content: { 'application/octet-stream': { schema: { type: 'string', format: 'binary' } } },
});
exports.FileResponse = FileResponse;
exports.GetLoginDetails = (0, common_1.createParamDecorator)((data, context) => {
    const request = context.switchToHttp().getRequest();
    const userAgent = (0, ua_parser_js_1.UAParser)(request.headers['user-agent']);
    return {
        clientIp: request.ip ?? '',
        isSecure: request.secure,
        deviceType: userAgent.browser.name || userAgent.device.type || request.headers.devicemodel || '',
        deviceOS: userAgent.os.name || request.headers.devicetype || '',
    };
});
let AuthGuard = AuthGuard_1 = class AuthGuard {
    logger;
    reflector;
    authService;
    constructor(logger, reflector, authService) {
        this.logger = logger;
        this.reflector = reflector;
        this.authService = authService;
        this.logger.setContext(AuthGuard_1.name);
    }
    async canActivate(context) {
        const targets = [context.getHandler()];
        const options = this.reflector.getAllAndOverride(enum_1.MetadataKey.AUTH_ROUTE, targets);
        if (!options) {
            return true;
        }
        const { admin: adminRoute, sharedLink: sharedLinkRoute, permission, } = { sharedLink: false, admin: false, ...options };
        const request = context.switchToHttp().getRequest();
        request.user = await this.authService.authenticate({
            headers: request.headers,
            queryParams: request.query,
            metadata: { adminRoute, sharedLinkRoute, permission, uri: request.path },
        });
        return true;
    }
};
exports.AuthGuard = AuthGuard;
exports.AuthGuard = AuthGuard = AuthGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        core_1.Reflector,
        auth_service_1.AuthService])
], AuthGuard);
//# sourceMappingURL=auth.guard.js.map