"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueCleanType = exports.JobStatus = exports.JobCommand = exports.JobName = exports.QueueName = exports.BootstrapEventPriority = exports.DatabaseExtension = exports.ExifOrientation = exports.ImmichTelemetry = exports.ImmichWorker = exports.ImmichEnvironment = exports.PaginationMode = exports.CacheControl = exports.RouteKey = exports.MetadataKey = exports.LogLevel = exports.ImageFormat = exports.Colorspace = exports.CQMode = exports.ToneMapping = exports.TranscodeHWAccel = exports.VideoContainer = exports.AudioCodec = exports.VideoCodec = exports.TranscodeTarget = exports.TranscodePolicy = exports.UserPathType = exports.PersonPathType = exports.AssetPathType = exports.ManualJobName = exports.SourceType = exports.AssetStatus = exports.UserStatus = exports.UserAvatarColor = exports.UserMetadataKey = exports.SystemMetadataKey = exports.StorageFolder = exports.SharedLinkType = exports.Permission = exports.MemoryType = exports.EntityType = exports.DatabaseAction = exports.AssetOrder = exports.AlbumUserRole = exports.AssetFileType = exports.AssetType = exports.ImmichQuery = exports.ImmichHeader = exports.ImmichCookie = exports.AuthType = void 0;
exports.SyncEntityType = exports.SyncRequestType = exports.DatabaseLock = exports.VectorIndex = void 0;
var AuthType;
(function (AuthType) {
    AuthType["PASSWORD"] = "password";
    AuthType["OAUTH"] = "oauth";
})(AuthType || (exports.AuthType = AuthType = {}));
var ImmichCookie;
(function (ImmichCookie) {
    ImmichCookie["ACCESS_TOKEN"] = "immich_access_token";
    ImmichCookie["AUTH_TYPE"] = "immich_auth_type";
    ImmichCookie["IS_AUTHENTICATED"] = "immich_is_authenticated";
    ImmichCookie["SHARED_LINK_TOKEN"] = "immich_shared_link_token";
    ImmichCookie["OAUTH_STATE"] = "immich_oauth_state";
    ImmichCookie["OAUTH_CODE_VERIFIER"] = "immich_oauth_code_verifier";
})(ImmichCookie || (exports.ImmichCookie = ImmichCookie = {}));
var ImmichHeader;
(function (ImmichHeader) {
    ImmichHeader["API_KEY"] = "x-api-key";
    ImmichHeader["USER_TOKEN"] = "x-immich-user-token";
    ImmichHeader["SESSION_TOKEN"] = "x-immich-session-token";
    ImmichHeader["SHARED_LINK_KEY"] = "x-immich-share-key";
    ImmichHeader["CHECKSUM"] = "x-immich-checksum";
    ImmichHeader["CID"] = "x-immich-cid";
})(ImmichHeader || (exports.ImmichHeader = ImmichHeader = {}));
var ImmichQuery;
(function (ImmichQuery) {
    ImmichQuery["SHARED_LINK_KEY"] = "key";
    ImmichQuery["API_KEY"] = "apiKey";
    ImmichQuery["SESSION_KEY"] = "sessionKey";
})(ImmichQuery || (exports.ImmichQuery = ImmichQuery = {}));
var AssetType;
(function (AssetType) {
    AssetType["IMAGE"] = "IMAGE";
    AssetType["VIDEO"] = "VIDEO";
    AssetType["AUDIO"] = "AUDIO";
    AssetType["OTHER"] = "OTHER";
})(AssetType || (exports.AssetType = AssetType = {}));
var AssetFileType;
(function (AssetFileType) {
    AssetFileType["FULLSIZE"] = "fullsize";
    AssetFileType["PREVIEW"] = "preview";
    AssetFileType["THUMBNAIL"] = "thumbnail";
})(AssetFileType || (exports.AssetFileType = AssetFileType = {}));
var AlbumUserRole;
(function (AlbumUserRole) {
    AlbumUserRole["EDITOR"] = "editor";
    AlbumUserRole["VIEWER"] = "viewer";
})(AlbumUserRole || (exports.AlbumUserRole = AlbumUserRole = {}));
var AssetOrder;
(function (AssetOrder) {
    AssetOrder["ASC"] = "asc";
    AssetOrder["DESC"] = "desc";
})(AssetOrder || (exports.AssetOrder = AssetOrder = {}));
var DatabaseAction;
(function (DatabaseAction) {
    DatabaseAction["CREATE"] = "CREATE";
    DatabaseAction["UPDATE"] = "UPDATE";
    DatabaseAction["DELETE"] = "DELETE";
})(DatabaseAction || (exports.DatabaseAction = DatabaseAction = {}));
var EntityType;
(function (EntityType) {
    EntityType["ASSET"] = "ASSET";
    EntityType["ALBUM"] = "ALBUM";
})(EntityType || (exports.EntityType = EntityType = {}));
var MemoryType;
(function (MemoryType) {
    MemoryType["ON_THIS_DAY"] = "on_this_day";
})(MemoryType || (exports.MemoryType = MemoryType = {}));
var Permission;
(function (Permission) {
    Permission["ALL"] = "all";
    Permission["ACTIVITY_CREATE"] = "activity.create";
    Permission["ACTIVITY_READ"] = "activity.read";
    Permission["ACTIVITY_UPDATE"] = "activity.update";
    Permission["ACTIVITY_DELETE"] = "activity.delete";
    Permission["ACTIVITY_STATISTICS"] = "activity.statistics";
    Permission["API_KEY_CREATE"] = "apiKey.create";
    Permission["API_KEY_READ"] = "apiKey.read";
    Permission["API_KEY_UPDATE"] = "apiKey.update";
    Permission["API_KEY_DELETE"] = "apiKey.delete";
    Permission["ASSET_READ"] = "asset.read";
    Permission["ASSET_UPDATE"] = "asset.update";
    Permission["ASSET_DELETE"] = "asset.delete";
    Permission["ASSET_SHARE"] = "asset.share";
    Permission["ASSET_VIEW"] = "asset.view";
    Permission["ASSET_DOWNLOAD"] = "asset.download";
    Permission["ASSET_UPLOAD"] = "asset.upload";
    Permission["ALBUM_CREATE"] = "album.create";
    Permission["ALBUM_READ"] = "album.read";
    Permission["ALBUM_UPDATE"] = "album.update";
    Permission["ALBUM_DELETE"] = "album.delete";
    Permission["ALBUM_STATISTICS"] = "album.statistics";
    Permission["ALBUM_ADD_ASSET"] = "album.addAsset";
    Permission["ALBUM_REMOVE_ASSET"] = "album.removeAsset";
    Permission["ALBUM_SHARE"] = "album.share";
    Permission["ALBUM_DOWNLOAD"] = "album.download";
    Permission["AUTH_DEVICE_DELETE"] = "authDevice.delete";
    Permission["ARCHIVE_READ"] = "archive.read";
    Permission["FACE_CREATE"] = "face.create";
    Permission["FACE_READ"] = "face.read";
    Permission["FACE_UPDATE"] = "face.update";
    Permission["FACE_DELETE"] = "face.delete";
    Permission["LIBRARY_CREATE"] = "library.create";
    Permission["LIBRARY_READ"] = "library.read";
    Permission["LIBRARY_UPDATE"] = "library.update";
    Permission["LIBRARY_DELETE"] = "library.delete";
    Permission["LIBRARY_STATISTICS"] = "library.statistics";
    Permission["TIMELINE_READ"] = "timeline.read";
    Permission["TIMELINE_DOWNLOAD"] = "timeline.download";
    Permission["MEMORY_CREATE"] = "memory.create";
    Permission["MEMORY_READ"] = "memory.read";
    Permission["MEMORY_UPDATE"] = "memory.update";
    Permission["MEMORY_DELETE"] = "memory.delete";
    Permission["PARTNER_CREATE"] = "partner.create";
    Permission["PARTNER_READ"] = "partner.read";
    Permission["PARTNER_UPDATE"] = "partner.update";
    Permission["PARTNER_DELETE"] = "partner.delete";
    Permission["PERSON_CREATE"] = "person.create";
    Permission["PERSON_READ"] = "person.read";
    Permission["PERSON_UPDATE"] = "person.update";
    Permission["PERSON_DELETE"] = "person.delete";
    Permission["PERSON_STATISTICS"] = "person.statistics";
    Permission["PERSON_MERGE"] = "person.merge";
    Permission["PERSON_REASSIGN"] = "person.reassign";
    Permission["SESSION_READ"] = "session.read";
    Permission["SESSION_UPDATE"] = "session.update";
    Permission["SESSION_DELETE"] = "session.delete";
    Permission["SHARED_LINK_CREATE"] = "sharedLink.create";
    Permission["SHARED_LINK_READ"] = "sharedLink.read";
    Permission["SHARED_LINK_UPDATE"] = "sharedLink.update";
    Permission["SHARED_LINK_DELETE"] = "sharedLink.delete";
    Permission["STACK_CREATE"] = "stack.create";
    Permission["STACK_READ"] = "stack.read";
    Permission["STACK_UPDATE"] = "stack.update";
    Permission["STACK_DELETE"] = "stack.delete";
    Permission["SYSTEM_CONFIG_READ"] = "systemConfig.read";
    Permission["SYSTEM_CONFIG_UPDATE"] = "systemConfig.update";
    Permission["SYSTEM_METADATA_READ"] = "systemMetadata.read";
    Permission["SYSTEM_METADATA_UPDATE"] = "systemMetadata.update";
    Permission["TAG_CREATE"] = "tag.create";
    Permission["TAG_READ"] = "tag.read";
    Permission["TAG_UPDATE"] = "tag.update";
    Permission["TAG_DELETE"] = "tag.delete";
    Permission["TAG_ASSET"] = "tag.asset";
    Permission["ADMIN_USER_CREATE"] = "admin.user.create";
    Permission["ADMIN_USER_READ"] = "admin.user.read";
    Permission["ADMIN_USER_UPDATE"] = "admin.user.update";
    Permission["ADMIN_USER_DELETE"] = "admin.user.delete";
})(Permission || (exports.Permission = Permission = {}));
var SharedLinkType;
(function (SharedLinkType) {
    SharedLinkType["ALBUM"] = "ALBUM";
    SharedLinkType["INDIVIDUAL"] = "INDIVIDUAL";
})(SharedLinkType || (exports.SharedLinkType = SharedLinkType = {}));
var StorageFolder;
(function (StorageFolder) {
    StorageFolder["ENCODED_VIDEO"] = "encoded-video";
    StorageFolder["LIBRARY"] = "library";
    StorageFolder["UPLOAD"] = "upload";
    StorageFolder["PROFILE"] = "profile";
    StorageFolder["THUMBNAILS"] = "thumbs";
    StorageFolder["BACKUPS"] = "backups";
})(StorageFolder || (exports.StorageFolder = StorageFolder = {}));
var SystemMetadataKey;
(function (SystemMetadataKey) {
    SystemMetadataKey["REVERSE_GEOCODING_STATE"] = "reverse-geocoding-state";
    SystemMetadataKey["FACIAL_RECOGNITION_STATE"] = "facial-recognition-state";
    SystemMetadataKey["MEMORIES_STATE"] = "memories-state";
    SystemMetadataKey["ADMIN_ONBOARDING"] = "admin-onboarding";
    SystemMetadataKey["SYSTEM_CONFIG"] = "system-config";
    SystemMetadataKey["SYSTEM_FLAGS"] = "system-flags";
    SystemMetadataKey["VERSION_CHECK_STATE"] = "version-check-state";
    SystemMetadataKey["LICENSE"] = "license";
})(SystemMetadataKey || (exports.SystemMetadataKey = SystemMetadataKey = {}));
var UserMetadataKey;
(function (UserMetadataKey) {
    UserMetadataKey["PREFERENCES"] = "preferences";
    UserMetadataKey["LICENSE"] = "license";
})(UserMetadataKey || (exports.UserMetadataKey = UserMetadataKey = {}));
var UserAvatarColor;
(function (UserAvatarColor) {
    UserAvatarColor["PRIMARY"] = "primary";
    UserAvatarColor["PINK"] = "pink";
    UserAvatarColor["RED"] = "red";
    UserAvatarColor["YELLOW"] = "yellow";
    UserAvatarColor["BLUE"] = "blue";
    UserAvatarColor["GREEN"] = "green";
    UserAvatarColor["PURPLE"] = "purple";
    UserAvatarColor["ORANGE"] = "orange";
    UserAvatarColor["GRAY"] = "gray";
    UserAvatarColor["AMBER"] = "amber";
})(UserAvatarColor || (exports.UserAvatarColor = UserAvatarColor = {}));
var UserStatus;
(function (UserStatus) {
    UserStatus["ACTIVE"] = "active";
    UserStatus["REMOVING"] = "removing";
    UserStatus["DELETED"] = "deleted";
})(UserStatus || (exports.UserStatus = UserStatus = {}));
var AssetStatus;
(function (AssetStatus) {
    AssetStatus["ACTIVE"] = "active";
    AssetStatus["TRASHED"] = "trashed";
    AssetStatus["DELETED"] = "deleted";
})(AssetStatus || (exports.AssetStatus = AssetStatus = {}));
var SourceType;
(function (SourceType) {
    SourceType["MACHINE_LEARNING"] = "machine-learning";
    SourceType["EXIF"] = "exif";
    SourceType["MANUAL"] = "manual";
})(SourceType || (exports.SourceType = SourceType = {}));
var ManualJobName;
(function (ManualJobName) {
    ManualJobName["PERSON_CLEANUP"] = "person-cleanup";
    ManualJobName["TAG_CLEANUP"] = "tag-cleanup";
    ManualJobName["USER_CLEANUP"] = "user-cleanup";
    ManualJobName["MEMORY_CLEANUP"] = "memory-cleanup";
    ManualJobName["MEMORY_CREATE"] = "memory-create";
    ManualJobName["BACKUP_DATABASE"] = "backup-database";
})(ManualJobName || (exports.ManualJobName = ManualJobName = {}));
var AssetPathType;
(function (AssetPathType) {
    AssetPathType["ORIGINAL"] = "original";
    AssetPathType["FULLSIZE"] = "fullsize";
    AssetPathType["PREVIEW"] = "preview";
    AssetPathType["THUMBNAIL"] = "thumbnail";
    AssetPathType["ENCODED_VIDEO"] = "encoded_video";
    AssetPathType["SIDECAR"] = "sidecar";
})(AssetPathType || (exports.AssetPathType = AssetPathType = {}));
var PersonPathType;
(function (PersonPathType) {
    PersonPathType["FACE"] = "face";
})(PersonPathType || (exports.PersonPathType = PersonPathType = {}));
var UserPathType;
(function (UserPathType) {
    UserPathType["PROFILE"] = "profile";
})(UserPathType || (exports.UserPathType = UserPathType = {}));
var TranscodePolicy;
(function (TranscodePolicy) {
    TranscodePolicy["ALL"] = "all";
    TranscodePolicy["OPTIMAL"] = "optimal";
    TranscodePolicy["BITRATE"] = "bitrate";
    TranscodePolicy["REQUIRED"] = "required";
    TranscodePolicy["DISABLED"] = "disabled";
})(TranscodePolicy || (exports.TranscodePolicy = TranscodePolicy = {}));
var TranscodeTarget;
(function (TranscodeTarget) {
    TranscodeTarget[TranscodeTarget["NONE"] = 0] = "NONE";
    TranscodeTarget[TranscodeTarget["AUDIO"] = 1] = "AUDIO";
    TranscodeTarget[TranscodeTarget["VIDEO"] = 2] = "VIDEO";
    TranscodeTarget[TranscodeTarget["ALL"] = 3] = "ALL";
})(TranscodeTarget || (exports.TranscodeTarget = TranscodeTarget = {}));
var VideoCodec;
(function (VideoCodec) {
    VideoCodec["H264"] = "h264";
    VideoCodec["HEVC"] = "hevc";
    VideoCodec["VP9"] = "vp9";
    VideoCodec["AV1"] = "av1";
})(VideoCodec || (exports.VideoCodec = VideoCodec = {}));
var AudioCodec;
(function (AudioCodec) {
    AudioCodec["MP3"] = "mp3";
    AudioCodec["AAC"] = "aac";
    AudioCodec["LIBOPUS"] = "libopus";
    AudioCodec["PCMS16LE"] = "pcm_s16le";
})(AudioCodec || (exports.AudioCodec = AudioCodec = {}));
var VideoContainer;
(function (VideoContainer) {
    VideoContainer["MOV"] = "mov";
    VideoContainer["MP4"] = "mp4";
    VideoContainer["OGG"] = "ogg";
    VideoContainer["WEBM"] = "webm";
})(VideoContainer || (exports.VideoContainer = VideoContainer = {}));
var TranscodeHWAccel;
(function (TranscodeHWAccel) {
    TranscodeHWAccel["NVENC"] = "nvenc";
    TranscodeHWAccel["QSV"] = "qsv";
    TranscodeHWAccel["VAAPI"] = "vaapi";
    TranscodeHWAccel["RKMPP"] = "rkmpp";
    TranscodeHWAccel["DISABLED"] = "disabled";
})(TranscodeHWAccel || (exports.TranscodeHWAccel = TranscodeHWAccel = {}));
var ToneMapping;
(function (ToneMapping) {
    ToneMapping["HABLE"] = "hable";
    ToneMapping["MOBIUS"] = "mobius";
    ToneMapping["REINHARD"] = "reinhard";
    ToneMapping["DISABLED"] = "disabled";
})(ToneMapping || (exports.ToneMapping = ToneMapping = {}));
var CQMode;
(function (CQMode) {
    CQMode["AUTO"] = "auto";
    CQMode["CQP"] = "cqp";
    CQMode["ICQ"] = "icq";
})(CQMode || (exports.CQMode = CQMode = {}));
var Colorspace;
(function (Colorspace) {
    Colorspace["SRGB"] = "srgb";
    Colorspace["P3"] = "p3";
})(Colorspace || (exports.Colorspace = Colorspace = {}));
var ImageFormat;
(function (ImageFormat) {
    ImageFormat["JPEG"] = "jpeg";
    ImageFormat["WEBP"] = "webp";
})(ImageFormat || (exports.ImageFormat = ImageFormat = {}));
var LogLevel;
(function (LogLevel) {
    LogLevel["VERBOSE"] = "verbose";
    LogLevel["DEBUG"] = "debug";
    LogLevel["LOG"] = "log";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["FATAL"] = "fatal";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
var MetadataKey;
(function (MetadataKey) {
    MetadataKey["AUTH_ROUTE"] = "auth_route";
    MetadataKey["ADMIN_ROUTE"] = "admin_route";
    MetadataKey["SHARED_ROUTE"] = "shared_route";
    MetadataKey["API_KEY_SECURITY"] = "api_key";
    MetadataKey["EVENT_CONFIG"] = "event_config";
    MetadataKey["JOB_CONFIG"] = "job_config";
    MetadataKey["TELEMETRY_ENABLED"] = "telemetry_enabled";
})(MetadataKey || (exports.MetadataKey = MetadataKey = {}));
var RouteKey;
(function (RouteKey) {
    RouteKey["ASSET"] = "assets";
    RouteKey["USER"] = "users";
})(RouteKey || (exports.RouteKey = RouteKey = {}));
var CacheControl;
(function (CacheControl) {
    CacheControl["PRIVATE_WITH_CACHE"] = "private_with_cache";
    CacheControl["PRIVATE_WITHOUT_CACHE"] = "private_without_cache";
    CacheControl["NONE"] = "none";
})(CacheControl || (exports.CacheControl = CacheControl = {}));
var PaginationMode;
(function (PaginationMode) {
    PaginationMode["LIMIT_OFFSET"] = "limit-offset";
    PaginationMode["SKIP_TAKE"] = "skip-take";
})(PaginationMode || (exports.PaginationMode = PaginationMode = {}));
var ImmichEnvironment;
(function (ImmichEnvironment) {
    ImmichEnvironment["DEVELOPMENT"] = "development";
    ImmichEnvironment["TESTING"] = "testing";
    ImmichEnvironment["PRODUCTION"] = "production";
})(ImmichEnvironment || (exports.ImmichEnvironment = ImmichEnvironment = {}));
var ImmichWorker;
(function (ImmichWorker) {
    ImmichWorker["API"] = "api";
    ImmichWorker["MICROSERVICES"] = "microservices";
})(ImmichWorker || (exports.ImmichWorker = ImmichWorker = {}));
var ImmichTelemetry;
(function (ImmichTelemetry) {
    ImmichTelemetry["HOST"] = "host";
    ImmichTelemetry["API"] = "api";
    ImmichTelemetry["IO"] = "io";
    ImmichTelemetry["REPO"] = "repo";
    ImmichTelemetry["JOB"] = "job";
})(ImmichTelemetry || (exports.ImmichTelemetry = ImmichTelemetry = {}));
var ExifOrientation;
(function (ExifOrientation) {
    ExifOrientation[ExifOrientation["Horizontal"] = 1] = "Horizontal";
    ExifOrientation[ExifOrientation["MirrorHorizontal"] = 2] = "MirrorHorizontal";
    ExifOrientation[ExifOrientation["Rotate180"] = 3] = "Rotate180";
    ExifOrientation[ExifOrientation["MirrorVertical"] = 4] = "MirrorVertical";
    ExifOrientation[ExifOrientation["MirrorHorizontalRotate270CW"] = 5] = "MirrorHorizontalRotate270CW";
    ExifOrientation[ExifOrientation["Rotate90CW"] = 6] = "Rotate90CW";
    ExifOrientation[ExifOrientation["MirrorHorizontalRotate90CW"] = 7] = "MirrorHorizontalRotate90CW";
    ExifOrientation[ExifOrientation["Rotate270CW"] = 8] = "Rotate270CW";
})(ExifOrientation || (exports.ExifOrientation = ExifOrientation = {}));
var DatabaseExtension;
(function (DatabaseExtension) {
    DatabaseExtension["CUBE"] = "cube";
    DatabaseExtension["EARTH_DISTANCE"] = "earthdistance";
    DatabaseExtension["VECTOR"] = "vector";
    DatabaseExtension["VECTORS"] = "vectors";
})(DatabaseExtension || (exports.DatabaseExtension = DatabaseExtension = {}));
var BootstrapEventPriority;
(function (BootstrapEventPriority) {
    BootstrapEventPriority[BootstrapEventPriority["DatabaseService"] = -200] = "DatabaseService";
    BootstrapEventPriority[BootstrapEventPriority["JobService"] = -190] = "JobService";
    BootstrapEventPriority[BootstrapEventPriority["SystemConfig"] = 100] = "SystemConfig";
})(BootstrapEventPriority || (exports.BootstrapEventPriority = BootstrapEventPriority = {}));
var QueueName;
(function (QueueName) {
    QueueName["THUMBNAIL_GENERATION"] = "thumbnailGeneration";
    QueueName["METADATA_EXTRACTION"] = "metadataExtraction";
    QueueName["VIDEO_CONVERSION"] = "videoConversion";
    QueueName["FACE_DETECTION"] = "faceDetection";
    QueueName["FACIAL_RECOGNITION"] = "facialRecognition";
    QueueName["SMART_SEARCH"] = "smartSearch";
    QueueName["DUPLICATE_DETECTION"] = "duplicateDetection";
    QueueName["BACKGROUND_TASK"] = "backgroundTask";
    QueueName["STORAGE_TEMPLATE_MIGRATION"] = "storageTemplateMigration";
    QueueName["MIGRATION"] = "migration";
    QueueName["SEARCH"] = "search";
    QueueName["SIDECAR"] = "sidecar";
    QueueName["LIBRARY"] = "library";
    QueueName["NOTIFICATION"] = "notifications";
    QueueName["BACKUP_DATABASE"] = "backupDatabase";
})(QueueName || (exports.QueueName = QueueName = {}));
var JobName;
(function (JobName) {
    JobName["BACKUP_DATABASE"] = "database-backup";
    JobName["QUEUE_VIDEO_CONVERSION"] = "queue-video-conversion";
    JobName["VIDEO_CONVERSION"] = "video-conversion";
    JobName["QUEUE_GENERATE_THUMBNAILS"] = "queue-generate-thumbnails";
    JobName["GENERATE_THUMBNAILS"] = "generate-thumbnails";
    JobName["GENERATE_PERSON_THUMBNAIL"] = "generate-person-thumbnail";
    JobName["QUEUE_METADATA_EXTRACTION"] = "queue-metadata-extraction";
    JobName["METADATA_EXTRACTION"] = "metadata-extraction";
    JobName["USER_DELETION"] = "user-deletion";
    JobName["USER_DELETE_CHECK"] = "user-delete-check";
    JobName["USER_SYNC_USAGE"] = "user-sync-usage";
    JobName["ASSET_DELETION"] = "asset-deletion";
    JobName["ASSET_DELETION_CHECK"] = "asset-deletion-check";
    JobName["STORAGE_TEMPLATE_MIGRATION"] = "storage-template-migration";
    JobName["STORAGE_TEMPLATE_MIGRATION_SINGLE"] = "storage-template-migration-single";
    JobName["TAG_CLEANUP"] = "tag-cleanup";
    JobName["QUEUE_MIGRATION"] = "queue-migration";
    JobName["MIGRATE_ASSET"] = "migrate-asset";
    JobName["MIGRATE_PERSON"] = "migrate-person";
    JobName["PERSON_CLEANUP"] = "person-cleanup";
    JobName["QUEUE_FACE_DETECTION"] = "queue-face-detection";
    JobName["FACE_DETECTION"] = "face-detection";
    JobName["QUEUE_FACIAL_RECOGNITION"] = "queue-facial-recognition";
    JobName["FACIAL_RECOGNITION"] = "facial-recognition";
    JobName["LIBRARY_QUEUE_SYNC_FILES"] = "library-queue-sync-files";
    JobName["LIBRARY_QUEUE_SYNC_ASSETS"] = "library-queue-sync-assets";
    JobName["LIBRARY_SYNC_FILES"] = "library-sync-files";
    JobName["LIBRARY_SYNC_ASSETS"] = "library-sync-assets";
    JobName["LIBRARY_ASSET_REMOVAL"] = "handle-library-file-deletion";
    JobName["LIBRARY_DELETE"] = "library-delete";
    JobName["LIBRARY_QUEUE_SCAN_ALL"] = "library-queue-scan-all";
    JobName["LIBRARY_QUEUE_CLEANUP"] = "library-queue-cleanup";
    JobName["DELETE_FILES"] = "delete-files";
    JobName["CLEAN_OLD_AUDIT_LOGS"] = "clean-old-audit-logs";
    JobName["CLEAN_OLD_SESSION_TOKENS"] = "clean-old-session-tokens";
    JobName["MEMORIES_CLEANUP"] = "memories-cleanup";
    JobName["MEMORIES_CREATE"] = "memories-create";
    JobName["QUEUE_SMART_SEARCH"] = "queue-smart-search";
    JobName["SMART_SEARCH"] = "smart-search";
    JobName["QUEUE_TRASH_EMPTY"] = "queue-trash-empty";
    JobName["QUEUE_DUPLICATE_DETECTION"] = "queue-duplicate-detection";
    JobName["DUPLICATE_DETECTION"] = "duplicate-detection";
    JobName["QUEUE_SIDECAR"] = "queue-sidecar";
    JobName["SIDECAR_DISCOVERY"] = "sidecar-discovery";
    JobName["SIDECAR_SYNC"] = "sidecar-sync";
    JobName["SIDECAR_WRITE"] = "sidecar-write";
    JobName["NOTIFY_SIGNUP"] = "notify-signup";
    JobName["NOTIFY_ALBUM_INVITE"] = "notify-album-invite";
    JobName["NOTIFY_ALBUM_UPDATE"] = "notify-album-update";
    JobName["SEND_EMAIL"] = "notification-send-email";
    JobName["VERSION_CHECK"] = "version-check";
})(JobName || (exports.JobName = JobName = {}));
var JobCommand;
(function (JobCommand) {
    JobCommand["START"] = "start";
    JobCommand["PAUSE"] = "pause";
    JobCommand["RESUME"] = "resume";
    JobCommand["EMPTY"] = "empty";
    JobCommand["CLEAR_FAILED"] = "clear-failed";
})(JobCommand || (exports.JobCommand = JobCommand = {}));
var JobStatus;
(function (JobStatus) {
    JobStatus["SUCCESS"] = "success";
    JobStatus["FAILED"] = "failed";
    JobStatus["SKIPPED"] = "skipped";
})(JobStatus || (exports.JobStatus = JobStatus = {}));
var QueueCleanType;
(function (QueueCleanType) {
    QueueCleanType["FAILED"] = "failed";
})(QueueCleanType || (exports.QueueCleanType = QueueCleanType = {}));
var VectorIndex;
(function (VectorIndex) {
    VectorIndex["CLIP"] = "clip_index";
    VectorIndex["FACE"] = "face_index";
})(VectorIndex || (exports.VectorIndex = VectorIndex = {}));
var DatabaseLock;
(function (DatabaseLock) {
    DatabaseLock[DatabaseLock["GeodataImport"] = 100] = "GeodataImport";
    DatabaseLock[DatabaseLock["Migrations"] = 200] = "Migrations";
    DatabaseLock[DatabaseLock["SystemFileMounts"] = 300] = "SystemFileMounts";
    DatabaseLock[DatabaseLock["StorageTemplateMigration"] = 420] = "StorageTemplateMigration";
    DatabaseLock[DatabaseLock["VersionHistory"] = 500] = "VersionHistory";
    DatabaseLock[DatabaseLock["CLIPDimSize"] = 512] = "CLIPDimSize";
    DatabaseLock[DatabaseLock["Library"] = 1337] = "Library";
    DatabaseLock[DatabaseLock["GetSystemConfig"] = 69] = "GetSystemConfig";
    DatabaseLock[DatabaseLock["BackupDatabase"] = 42] = "BackupDatabase";
})(DatabaseLock || (exports.DatabaseLock = DatabaseLock = {}));
var SyncRequestType;
(function (SyncRequestType) {
    SyncRequestType["UsersV1"] = "UsersV1";
    SyncRequestType["PartnersV1"] = "PartnersV1";
    SyncRequestType["AssetsV1"] = "AssetsV1";
    SyncRequestType["AssetExifsV1"] = "AssetExifsV1";
    SyncRequestType["PartnerAssetsV1"] = "PartnerAssetsV1";
    SyncRequestType["PartnerAssetExifsV1"] = "PartnerAssetExifsV1";
})(SyncRequestType || (exports.SyncRequestType = SyncRequestType = {}));
var SyncEntityType;
(function (SyncEntityType) {
    SyncEntityType["UserV1"] = "UserV1";
    SyncEntityType["UserDeleteV1"] = "UserDeleteV1";
    SyncEntityType["PartnerV1"] = "PartnerV1";
    SyncEntityType["PartnerDeleteV1"] = "PartnerDeleteV1";
    SyncEntityType["AssetV1"] = "AssetV1";
    SyncEntityType["AssetDeleteV1"] = "AssetDeleteV1";
    SyncEntityType["AssetExifV1"] = "AssetExifV1";
    SyncEntityType["PartnerAssetV1"] = "PartnerAssetV1";
    SyncEntityType["PartnerAssetDeleteV1"] = "PartnerAssetDeleteV1";
    SyncEntityType["PartnerAssetExifV1"] = "PartnerAssetExifV1";
})(SyncEntityType || (exports.SyncEntityType = SyncEntityType = {}));
//# sourceMappingURL=enum.js.map