import { User, UserAdmin } from 'src/database';
import { UserAvatarColor } from 'src/enum';
export declare class UserUpdateMeDto {
    email?: string;
    password?: string;
    name?: string;
}
export declare class UserResponseDto {
    id: string;
    name: string;
    email: string;
    profileImagePath: string;
    avatarColor: UserAvatarColor;
    profileChangedAt: Date;
}
export declare class UserLicense {
    licenseKey: string;
    activationKey: string;
    activatedAt: Date;
}
export declare const mapUser: (entity: User | UserAdmin) => UserResponseDto;
export declare class UserAdminSearchDto {
    withDeleted?: boolean;
}
export declare class UserAdminCreateDto {
    email: string;
    password: string;
    name: string;
    storageLabel?: string | null;
    quotaSizeInBytes?: number | null;
    shouldChangePassword?: boolean;
    notify?: boolean;
}
export declare class UserAdminUpdateDto {
    email?: string;
    password?: string;
    name?: string;
    storageLabel?: string | null;
    shouldChangePassword?: boolean;
    quotaSizeInBytes?: number | null;
}
export declare class UserAdminDeleteDto {
    force?: boolean;
}
export declare class UserAdminResponseDto extends UserResponseDto {
    storageLabel: string | null;
    shouldChangePassword: boolean;
    isAdmin: boolean;
    createdAt: Date;
    deletedAt: Date | null;
    updatedAt: Date;
    oauthId: string;
    quotaSizeInBytes: number | null;
    quotaUsageInBytes: number | null;
    status: string;
    license: UserLicense | null;
}
export declare function mapUserAdmin(entity: UserAdmin): UserAdminResponseDto;
