import { UserAvatarColor } from 'src/enum';
import { UserPreferences } from 'src/types';
declare class AvatarUpdate {
    color?: UserAvatarColor;
}
declare class MemoriesUpdate {
    enabled?: boolean;
}
declare class RatingsUpdate {
    enabled?: boolean;
}
declare class FoldersUpdate {
    enabled?: boolean;
    sidebarWeb?: boolean;
}
declare class PeopleUpdate {
    enabled?: boolean;
    sidebarWeb?: boolean;
}
declare class SharedLinksUpdate {
    enabled?: boolean;
    sidebarWeb?: boolean;
}
declare class TagsUpdate {
    enabled?: boolean;
    sidebarWeb?: boolean;
}
declare class EmailNotificationsUpdate {
    enabled?: boolean;
    albumInvite?: boolean;
    albumUpdate?: boolean;
}
declare class DownloadUpdate implements Partial<DownloadResponse> {
    archiveSize?: number;
    includeEmbeddedVideos?: boolean;
}
declare class PurchaseUpdate {
    showSupportBadge?: boolean;
    hideBuyButtonUntil?: string;
}
export declare class UserPreferencesUpdateDto {
    folders?: FoldersUpdate;
    memories?: MemoriesUpdate;
    people?: PeopleUpdate;
    ratings?: RatingsUpdate;
    sharedLinks?: SharedLinksUpdate;
    tags?: TagsUpdate;
    avatar?: AvatarUpdate;
    emailNotifications?: EmailNotificationsUpdate;
    download?: DownloadUpdate;
    purchase?: PurchaseUpdate;
}
declare class AvatarResponse {
    color: UserAvatarColor;
}
declare class RatingsResponse {
    enabled: boolean;
}
declare class MemoriesResponse {
    enabled: boolean;
}
declare class FoldersResponse {
    enabled: boolean;
    sidebarWeb: boolean;
}
declare class PeopleResponse {
    enabled: boolean;
    sidebarWeb: boolean;
}
declare class TagsResponse {
    enabled: boolean;
    sidebarWeb: boolean;
}
declare class SharedLinksResponse {
    enabled: boolean;
    sidebarWeb: boolean;
}
declare class EmailNotificationsResponse {
    enabled: boolean;
    albumInvite: boolean;
    albumUpdate: boolean;
}
declare class DownloadResponse {
    archiveSize: number;
    includeEmbeddedVideos: boolean;
}
declare class PurchaseResponse {
    showSupportBadge: boolean;
    hideBuyButtonUntil: string;
}
export declare class UserPreferencesResponseDto implements UserPreferences {
    folders: FoldersResponse;
    memories: MemoriesResponse;
    people: PeopleResponse;
    ratings: RatingsResponse;
    sharedLinks: SharedLinksResponse;
    tags: TagsResponse;
    avatar: AvatarResponse;
    emailNotifications: EmailNotificationsResponse;
    download: DownloadResponse;
    purchase: PurchaseResponse;
}
export declare const mapPreferences: (preferences: UserPreferences) => UserPreferencesResponseDto;
export {};
