"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeBucketResponseDto = exports.TimeBucketAssetDto = exports.TimeBucketDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const asset_repository_1 = require("../repositories/asset.repository");
const validation_1 = require("../validation");
class TimeBucketDto {
    size;
    userId;
    albumId;
    personId;
    tagId;
    isArchived;
    isFavorite;
    isTrashed;
    withStacked;
    withPartners;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { size: { required: true, enum: require("../repositories/asset.repository").TimeBucketSize }, userId: { required: false, type: () => String }, albumId: { required: false, type: () => String }, personId: { required: false, type: () => String }, tagId: { required: false, type: () => String }, isArchived: { required: false, type: () => Boolean }, isFavorite: { required: false, type: () => Boolean }, isTrashed: { required: false, type: () => Boolean }, withStacked: { required: false, type: () => Boolean }, withPartners: { required: false, type: () => Boolean }, order: { required: false, enum: require("../enum").AssetOrder } };
    }
}
exports.TimeBucketDto = TimeBucketDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsEnum)(asset_repository_1.TimeBucketSize),
    (0, swagger_1.ApiProperty)({ enum: asset_repository_1.TimeBucketSize, enumName: 'TimeBucketSize' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "size", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "userId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "albumId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "personId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "tagId", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "isArchived", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "isTrashed", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "withStacked", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], TimeBucketDto.prototype, "withPartners", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.AssetOrder),
    (0, validation_1.Optional)(),
    (0, swagger_1.ApiProperty)({ enum: enum_1.AssetOrder, enumName: 'AssetOrder' }),
    __metadata("design:type", String)
], TimeBucketDto.prototype, "order", void 0);
class TimeBucketAssetDto extends TimeBucketDto {
    timeBucket;
    static _OPENAPI_METADATA_FACTORY() {
        return { timeBucket: { required: true, type: () => String } };
    }
}
exports.TimeBucketAssetDto = TimeBucketAssetDto;
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], TimeBucketAssetDto.prototype, "timeBucket", void 0);
class TimeBucketResponseDto {
    timeBucket;
    count;
    static _OPENAPI_METADATA_FACTORY() {
        return { timeBucket: { required: true, type: () => String }, count: { required: true, type: () => Number } };
    }
}
exports.TimeBucketResponseDto = TimeBucketResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string' }),
    __metadata("design:type", String)
], TimeBucketResponseDto.prototype, "timeBucket", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], TimeBucketResponseDto.prototype, "count", void 0);
//# sourceMappingURL=time-bucket.dto.js.map