"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncAckDeleteDto = exports.SyncAckSetDto = exports.SyncAckDto = exports.SyncStreamDto = exports.extraSyncModels = exports.SyncAssetExifV1 = exports.SyncAssetDeleteV1 = exports.SyncAssetV1 = exports.SyncPartnerDeleteV1 = exports.SyncPartnerV1 = exports.SyncUserDeleteV1 = exports.SyncUserV1 = exports.AssetDeltaSyncResponseDto = exports.AssetDeltaSyncDto = exports.AssetFullSyncDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class AssetFullSyncDto {
    lastId;
    updatedUntil;
    limit;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { lastId: { required: false, type: () => String }, updatedUntil: { required: true, type: () => Date }, limit: { required: true, type: () => Number, minimum: 1 }, userId: { required: false, type: () => String } };
    }
}
exports.AssetFullSyncDto = AssetFullSyncDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], AssetFullSyncDto.prototype, "lastId", void 0);
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetFullSyncDto.prototype, "updatedUntil", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFullSyncDto.prototype, "limit", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], AssetFullSyncDto.prototype, "userId", void 0);
class AssetDeltaSyncDto {
    updatedAfter;
    userIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { updatedAfter: { required: true, type: () => Date }, userIds: { required: true, type: () => [String] } };
    }
}
exports.AssetDeltaSyncDto = AssetDeltaSyncDto;
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetDeltaSyncDto.prototype, "updatedAfter", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], AssetDeltaSyncDto.prototype, "userIds", void 0);
class AssetDeltaSyncResponseDto {
    needsFullSync;
    upserted;
    deleted;
    static _OPENAPI_METADATA_FACTORY() {
        return { needsFullSync: { required: true, type: () => Boolean }, upserted: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] }, deleted: { required: true, type: () => [String] } };
    }
}
exports.AssetDeltaSyncResponseDto = AssetDeltaSyncResponseDto;
class SyncUserV1 {
    id;
    name;
    email;
    deletedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, email: { required: true, type: () => String }, deletedAt: { required: true, type: () => Date, nullable: true } };
    }
}
exports.SyncUserV1 = SyncUserV1;
class SyncUserDeleteV1 {
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String } };
    }
}
exports.SyncUserDeleteV1 = SyncUserDeleteV1;
class SyncPartnerV1 {
    sharedById;
    sharedWithId;
    inTimeline;
    static _OPENAPI_METADATA_FACTORY() {
        return { sharedById: { required: true, type: () => String }, sharedWithId: { required: true, type: () => String }, inTimeline: { required: true, type: () => Boolean } };
    }
}
exports.SyncPartnerV1 = SyncPartnerV1;
class SyncPartnerDeleteV1 {
    sharedById;
    sharedWithId;
    static _OPENAPI_METADATA_FACTORY() {
        return { sharedById: { required: true, type: () => String }, sharedWithId: { required: true, type: () => String } };
    }
}
exports.SyncPartnerDeleteV1 = SyncPartnerDeleteV1;
class SyncAssetV1 {
    id;
    ownerId;
    thumbhash;
    checksum;
    fileCreatedAt;
    fileModifiedAt;
    localDateTime;
    type;
    deletedAt;
    isFavorite;
    isVisible;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, thumbhash: { required: true, type: () => String, nullable: true }, checksum: { required: true, type: () => String }, fileCreatedAt: { required: true, type: () => Date, nullable: true }, fileModifiedAt: { required: true, type: () => Date, nullable: true }, localDateTime: { required: true, type: () => Date, nullable: true }, type: { required: true, enum: require("../enum").AssetType }, deletedAt: { required: true, type: () => Date, nullable: true }, isFavorite: { required: true, type: () => Boolean }, isVisible: { required: true, type: () => Boolean } };
    }
}
exports.SyncAssetV1 = SyncAssetV1;
class SyncAssetDeleteV1 {
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String } };
    }
}
exports.SyncAssetDeleteV1 = SyncAssetDeleteV1;
class SyncAssetExifV1 {
    assetId;
    description;
    exifImageWidth;
    exifImageHeight;
    fileSizeInByte;
    orientation;
    dateTimeOriginal;
    modifyDate;
    timeZone;
    latitude;
    longitude;
    projectionType;
    city;
    state;
    country;
    make;
    model;
    lensModel;
    fNumber;
    focalLength;
    iso;
    exposureTime;
    profileDescription;
    rating;
    fps;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetId: { required: true, type: () => String }, description: { required: true, type: () => String, nullable: true }, exifImageWidth: { required: true, type: () => Number, nullable: true }, exifImageHeight: { required: true, type: () => Number, nullable: true }, fileSizeInByte: { required: true, type: () => Number, nullable: true }, orientation: { required: true, type: () => String, nullable: true }, dateTimeOriginal: { required: true, type: () => Date, nullable: true }, modifyDate: { required: true, type: () => Date, nullable: true }, timeZone: { required: true, type: () => String, nullable: true }, latitude: { required: true, type: () => Number, nullable: true }, longitude: { required: true, type: () => Number, nullable: true }, projectionType: { required: true, type: () => String, nullable: true }, city: { required: true, type: () => String, nullable: true }, state: { required: true, type: () => String, nullable: true }, country: { required: true, type: () => String, nullable: true }, make: { required: true, type: () => String, nullable: true }, model: { required: true, type: () => String, nullable: true }, lensModel: { required: true, type: () => String, nullable: true }, fNumber: { required: true, type: () => Number, nullable: true }, focalLength: { required: true, type: () => Number, nullable: true }, iso: { required: true, type: () => Number, nullable: true }, exposureTime: { required: true, type: () => String, nullable: true }, profileDescription: { required: true, type: () => String, nullable: true }, rating: { required: true, type: () => Number, nullable: true }, fps: { required: true, type: () => Number, nullable: true } };
    }
}
exports.SyncAssetExifV1 = SyncAssetExifV1;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "exifImageWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "exifImageHeight", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fileSizeInByte", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "latitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "longitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "focalLength", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "iso", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "rating", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], SyncAssetExifV1.prototype, "fps", void 0);
const responseDtos = [
    SyncUserV1,
    SyncUserDeleteV1,
    SyncPartnerV1,
    SyncPartnerDeleteV1,
    SyncAssetV1,
    SyncAssetDeleteV1,
    SyncAssetExifV1,
];
exports.extraSyncModels = responseDtos;
class SyncStreamDto {
    types;
    static _OPENAPI_METADATA_FACTORY() {
        return { types: { required: true, enum: require("../enum").SyncRequestType, isArray: true } };
    }
}
exports.SyncStreamDto = SyncStreamDto;
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.SyncRequestType, { each: true }),
    (0, swagger_1.ApiProperty)({ enumName: 'SyncRequestType', enum: enum_1.SyncRequestType, isArray: true }),
    __metadata("design:type", Array)
], SyncStreamDto.prototype, "types", void 0);
class SyncAckDto {
    type;
    ack;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("../enum").SyncEntityType }, ack: { required: true, type: () => String } };
    }
}
exports.SyncAckDto = SyncAckDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enumName: 'SyncEntityType', enum: enum_1.SyncEntityType }),
    __metadata("design:type", String)
], SyncAckDto.prototype, "type", void 0);
class SyncAckSetDto {
    acks;
    static _OPENAPI_METADATA_FACTORY() {
        return { acks: { required: true, type: () => [String] } };
    }
}
exports.SyncAckSetDto = SyncAckSetDto;
__decorate([
    (0, class_validator_1.IsString)({ each: true }),
    __metadata("design:type", Array)
], SyncAckSetDto.prototype, "acks", void 0);
class SyncAckDeleteDto {
    types;
    static _OPENAPI_METADATA_FACTORY() {
        return { types: { required: false, enum: require("../enum").SyncEntityType, isArray: true } };
    }
}
exports.SyncAckDeleteDto = SyncAckDeleteDto;
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.SyncEntityType, { each: true }),
    (0, swagger_1.ApiProperty)({ enumName: 'SyncEntityType', enum: enum_1.SyncEntityType, isArray: true }),
    (0, validation_1.Optional)(),
    __metadata("design:type", Array)
], SyncAckDeleteDto.prototype, "types", void 0);
//# sourceMappingURL=sync.dto.js.map