import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetType, SyncEntityType, SyncRequestType } from 'src/enum';
export declare class AssetFullSyncDto {
    lastId?: string;
    updatedUntil: Date;
    limit: number;
    userId?: string;
}
export declare class AssetDeltaSyncDto {
    updatedAfter: Date;
    userIds: string[];
}
export declare class AssetDeltaSyncResponseDto {
    needsFullSync: boolean;
    upserted: AssetResponseDto[];
    deleted: string[];
}
export declare class SyncUserV1 {
    id: string;
    name: string;
    email: string;
    deletedAt: Date | null;
}
export declare class SyncUserDeleteV1 {
    userId: string;
}
export declare class SyncPartnerV1 {
    sharedById: string;
    sharedWithId: string;
    inTimeline: boolean;
}
export declare class SyncPartnerDeleteV1 {
    sharedById: string;
    sharedWithId: string;
}
export declare class SyncAssetV1 {
    id: string;
    ownerId: string;
    thumbhash: string | null;
    checksum: string;
    fileCreatedAt: Date | null;
    fileModifiedAt: Date | null;
    localDateTime: Date | null;
    type: AssetType;
    deletedAt: Date | null;
    isFavorite: boolean;
    isVisible: boolean;
}
export declare class SyncAssetDeleteV1 {
    assetId: string;
}
export declare class SyncAssetExifV1 {
    assetId: string;
    description: string | null;
    exifImageWidth: number | null;
    exifImageHeight: number | null;
    fileSizeInByte: number | null;
    orientation: string | null;
    dateTimeOriginal: Date | null;
    modifyDate: Date | null;
    timeZone: string | null;
    latitude: number | null;
    longitude: number | null;
    projectionType: string | null;
    city: string | null;
    state: string | null;
    country: string | null;
    make: string | null;
    model: string | null;
    lensModel: string | null;
    fNumber: number | null;
    focalLength: number | null;
    iso: number | null;
    exposureTime: string | null;
    profileDescription: string | null;
    rating: number | null;
    fps: number | null;
}
export type SyncItem = {
    [SyncEntityType.UserV1]: SyncUserV1;
    [SyncEntityType.UserDeleteV1]: SyncUserDeleteV1;
    [SyncEntityType.PartnerV1]: SyncPartnerV1;
    [SyncEntityType.PartnerDeleteV1]: SyncPartnerDeleteV1;
    [SyncEntityType.AssetV1]: SyncAssetV1;
    [SyncEntityType.AssetDeleteV1]: SyncAssetDeleteV1;
    [SyncEntityType.AssetExifV1]: SyncAssetExifV1;
    [SyncEntityType.PartnerAssetV1]: SyncAssetV1;
    [SyncEntityType.PartnerAssetDeleteV1]: SyncAssetDeleteV1;
    [SyncEntityType.PartnerAssetExifV1]: SyncAssetExifV1;
};
export declare const extraSyncModels: (typeof SyncUserV1 | typeof SyncUserDeleteV1 | typeof SyncPartnerDeleteV1 | typeof SyncAssetV1 | typeof SyncAssetDeleteV1)[];
export declare class SyncStreamDto {
    types: SyncRequestType[];
}
export declare class SyncAckDto {
    type: SyncEntityType;
    ack: string;
}
export declare class SyncAckSetDto {
    acks: string[];
}
export declare class SyncAckDeleteDto {
    types?: SyncEntityType[];
}
