import { SharedLink } from 'src/database';
import { AlbumResponseDto } from 'src/dtos/album.dto';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { SharedLinkType } from 'src/enum';
export declare class SharedLinkSearchDto {
    albumId?: string;
}
export declare class SharedLinkCreateDto {
    type: SharedLinkType;
    assetIds?: string[];
    albumId?: string;
    description?: string;
    password?: string;
    expiresAt?: Date | null;
    allowUpload?: boolean;
    allowDownload?: boolean;
    showMetadata?: boolean;
}
export declare class SharedLinkEditDto {
    description?: string;
    password?: string;
    expiresAt?: Date | null;
    allowUpload?: boolean;
    allowDownload?: boolean;
    showMetadata?: boolean;
    changeExpiryTime?: boolean;
}
export declare class SharedLinkPasswordDto {
    password?: string;
    token?: string;
}
export declare class SharedLinkResponseDto {
    id: string;
    description: string | null;
    password: string | null;
    token?: string | null;
    userId: string;
    key: string;
    type: SharedLinkType;
    createdAt: Date;
    expiresAt: Date | null;
    assets: AssetResponseDto[];
    album?: AlbumResponseDto;
    allowUpload: boolean;
    allowDownload: boolean;
    showMetadata: boolean;
}
export declare function mapSharedLink(sharedLink: SharedLink): SharedLinkResponseDto;
export declare function mapSharedLinkWithoutMetadata(sharedLink: SharedLink): SharedLinkResponseDto;
