"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapSession = exports.SessionResponseDto = void 0;
const openapi = require("@nestjs/swagger");
class SessionResponseDto {
    id;
    createdAt;
    updatedAt;
    current;
    deviceType;
    deviceOS;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => String }, updatedAt: { required: true, type: () => String }, current: { required: true, type: () => Boolean }, deviceType: { required: true, type: () => String }, deviceOS: { required: true, type: () => String } };
    }
}
exports.SessionResponseDto = SessionResponseDto;
const mapSession = (entity, currentId) => ({
    id: entity.id,
    createdAt: entity.createdAt.toISOString(),
    updatedAt: entity.updatedAt.toISOString(),
    current: currentId === entity.id,
    deviceOS: entity.deviceOS,
    deviceType: entity.deviceType,
});
exports.mapSession = mapSession;
//# sourceMappingURL=session.dto.js.map