"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeopleResponseDto = exports.PersonStatisticsResponseDto = exports.AssetFaceDeleteDto = exports.AssetFaceCreateDto = exports.AssetFaceUpdateItem = exports.FaceDto = exports.AssetFaceUpdateDto = exports.AssetFaceResponseDto = exports.AssetFaceWithoutPersonResponseDto = exports.PersonWithFacesResponseDto = exports.PersonResponseDto = exports.PersonSearchDto = exports.MergePersonDto = exports.PeopleUpdateItem = exports.PeopleUpdateDto = exports.PersonUpdateDto = exports.PersonCreateDto = void 0;
exports.mapPerson = mapPerson;
exports.mapFacesWithoutPerson = mapFacesWithoutPerson;
exports.mapFaces = mapFaces;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const luxon_1 = require("luxon");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const date_1 = require("../utils/date");
const validation_1 = require("../validation");
class PersonCreateDto {
    name;
    birthDate;
    isHidden;
    isFavorite;
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: false, type: () => String, description: "Person name." }, birthDate: { required: false, type: () => Date, nullable: true, description: "Person date of birth.\nNote: the mobile app cannot currently set the birth date to null." }, isHidden: { required: false, type: () => Boolean, description: "Person visibility" }, isFavorite: { required: false, type: () => Boolean }, color: { required: false, type: () => String, nullable: true } };
    }
}
exports.PersonCreateDto = PersonCreateDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], PersonCreateDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'date' }),
    (0, validation_1.MaxDateString)(() => luxon_1.DateTime.now(), { message: 'Birth date cannot be in the future' }),
    (0, validation_1.IsDateStringFormat)('yyyy-MM-dd'),
    (0, validation_1.Optional)({ nullable: true }),
    __metadata("design:type", Object)
], PersonCreateDto.prototype, "birthDate", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], PersonCreateDto.prototype, "isHidden", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], PersonCreateDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.Optional)({ emptyToNull: true, nullable: true }),
    (0, validation_1.ValidateHexColor)(),
    __metadata("design:type", Object)
], PersonCreateDto.prototype, "color", void 0);
class PersonUpdateDto extends PersonCreateDto {
    featureFaceAssetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { featureFaceAssetId: { required: false, type: () => String, description: "Asset is used to get the feature face thumbnail." } };
    }
}
exports.PersonUpdateDto = PersonUpdateDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], PersonUpdateDto.prototype, "featureFaceAssetId", void 0);
class PeopleUpdateDto {
    people;
    static _OPENAPI_METADATA_FACTORY() {
        return { people: { required: true, type: () => [require("./person.dto").PeopleUpdateItem] } };
    }
}
exports.PeopleUpdateDto = PeopleUpdateDto;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => PeopleUpdateItem),
    __metadata("design:type", Array)
], PeopleUpdateDto.prototype, "people", void 0);
class PeopleUpdateItem extends PersonUpdateDto {
    id;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String, description: "Person id." } };
    }
}
exports.PeopleUpdateItem = PeopleUpdateItem;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PeopleUpdateItem.prototype, "id", void 0);
class MergePersonDto {
    ids;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] } };
    }
}
exports.MergePersonDto = MergePersonDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], MergePersonDto.prototype, "ids", void 0);
class PersonSearchDto {
    withHidden;
    closestPersonId;
    closestAssetId;
    page = 1;
    size = 500;
    static _OPENAPI_METADATA_FACTORY() {
        return { withHidden: { required: false, type: () => Boolean }, closestPersonId: { required: false, type: () => String }, closestAssetId: { required: false, type: () => String }, page: { required: true, type: () => Number, description: "Page number for pagination", default: 1, minimum: 1 }, size: { required: true, type: () => Number, description: "Number of items per page", default: 500, minimum: 1, maximum: 1000 } };
    }
}
exports.PersonSearchDto = PersonSearchDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], PersonSearchDto.prototype, "withHidden", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], PersonSearchDto.prototype, "closestPersonId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], PersonSearchDto.prototype, "closestAssetId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], PersonSearchDto.prototype, "page", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(1),
    (0, class_validator_1.Max)(1000),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], PersonSearchDto.prototype, "size", void 0);
class PersonResponseDto {
    id;
    name;
    birthDate;
    thumbnailPath;
    isHidden;
    updatedAt;
    isFavorite;
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, birthDate: { required: true, type: () => String, nullable: true }, thumbnailPath: { required: true, type: () => String }, isHidden: { required: true, type: () => Boolean }, updatedAt: { required: false, type: () => Date }, isFavorite: { required: false, type: () => Boolean }, color: { required: false, type: () => String } };
    }
}
exports.PersonResponseDto = PersonResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'date' }),
    __metadata("design:type", Object)
], PersonResponseDto.prototype, "birthDate", void 0);
__decorate([
    (0, decorators_1.PropertyLifecycle)({ addedAt: 'v1.107.0' }),
    __metadata("design:type", Date)
], PersonResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, decorators_1.PropertyLifecycle)({ addedAt: 'v1.126.0' }),
    __metadata("design:type", Boolean)
], PersonResponseDto.prototype, "isFavorite", void 0);
__decorate([
    (0, decorators_1.PropertyLifecycle)({ addedAt: 'v1.126.0' }),
    __metadata("design:type", String)
], PersonResponseDto.prototype, "color", void 0);
class PersonWithFacesResponseDto extends PersonResponseDto {
    faces;
    static _OPENAPI_METADATA_FACTORY() {
        return { faces: { required: true, type: () => [require("./person.dto").AssetFaceWithoutPersonResponseDto] } };
    }
}
exports.PersonWithFacesResponseDto = PersonWithFacesResponseDto;
class AssetFaceWithoutPersonResponseDto {
    id;
    imageHeight;
    imageWidth;
    boundingBoxX1;
    boundingBoxX2;
    boundingBoxY1;
    boundingBoxY2;
    sourceType;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, imageHeight: { required: true, type: () => Number }, imageWidth: { required: true, type: () => Number }, boundingBoxX1: { required: true, type: () => Number }, boundingBoxX2: { required: true, type: () => Number }, boundingBoxY1: { required: true, type: () => Number }, boundingBoxY2: { required: true, type: () => Number }, sourceType: { required: false, enum: require("../enum").SourceType } };
    }
}
exports.AssetFaceWithoutPersonResponseDto = AssetFaceWithoutPersonResponseDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], AssetFaceWithoutPersonResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "imageHeight", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "imageWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "boundingBoxX1", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "boundingBoxX2", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "boundingBoxY1", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceWithoutPersonResponseDto.prototype, "boundingBoxY2", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: enum_1.SourceType, enumName: 'SourceType' }),
    __metadata("design:type", String)
], AssetFaceWithoutPersonResponseDto.prototype, "sourceType", void 0);
class AssetFaceResponseDto extends AssetFaceWithoutPersonResponseDto {
    person;
    static _OPENAPI_METADATA_FACTORY() {
        return { person: { required: true, type: () => require("./person.dto").PersonResponseDto, nullable: true } };
    }
}
exports.AssetFaceResponseDto = AssetFaceResponseDto;
class AssetFaceUpdateDto {
    data;
    static _OPENAPI_METADATA_FACTORY() {
        return { data: { required: true, type: () => [require("./person.dto").AssetFaceUpdateItem] } };
    }
}
exports.AssetFaceUpdateDto = AssetFaceUpdateDto;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AssetFaceUpdateItem),
    __metadata("design:type", Array)
], AssetFaceUpdateDto.prototype, "data", void 0);
class FaceDto {
    id;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String } };
    }
}
exports.FaceDto = FaceDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], FaceDto.prototype, "id", void 0);
class AssetFaceUpdateItem {
    personId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { personId: { required: true, type: () => String }, assetId: { required: true, type: () => String } };
    }
}
exports.AssetFaceUpdateItem = AssetFaceUpdateItem;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], AssetFaceUpdateItem.prototype, "personId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], AssetFaceUpdateItem.prototype, "assetId", void 0);
class AssetFaceCreateDto extends AssetFaceUpdateItem {
    imageWidth;
    imageHeight;
    x;
    y;
    width;
    height;
    static _OPENAPI_METADATA_FACTORY() {
        return { imageWidth: { required: true, type: () => Number }, imageHeight: { required: true, type: () => Number }, x: { required: true, type: () => Number }, y: { required: true, type: () => Number }, width: { required: true, type: () => Number }, height: { required: true, type: () => Number } };
    }
}
exports.AssetFaceCreateDto = AssetFaceCreateDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "imageWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "imageHeight", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "x", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "y", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "width", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], AssetFaceCreateDto.prototype, "height", void 0);
class AssetFaceDeleteDto {
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { force: { required: true, type: () => Boolean } };
    }
}
exports.AssetFaceDeleteDto = AssetFaceDeleteDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Boolean)
], AssetFaceDeleteDto.prototype, "force", void 0);
class PersonStatisticsResponseDto {
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { assets: { required: true, type: () => Number } };
    }
}
exports.PersonStatisticsResponseDto = PersonStatisticsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], PersonStatisticsResponseDto.prototype, "assets", void 0);
class PeopleResponseDto {
    total;
    hidden;
    people;
    hasNextPage;
    static _OPENAPI_METADATA_FACTORY() {
        return { total: { required: true, type: () => Number }, hidden: { required: true, type: () => Number }, people: { required: true, type: () => [require("./person.dto").PersonResponseDto] }, hasNextPage: { required: false, type: () => Boolean } };
    }
}
exports.PeopleResponseDto = PeopleResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], PeopleResponseDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], PeopleResponseDto.prototype, "hidden", void 0);
__decorate([
    (0, decorators_1.PropertyLifecycle)({ addedAt: 'v1.110.0' }),
    __metadata("design:type", Boolean)
], PeopleResponseDto.prototype, "hasNextPage", void 0);
function mapPerson(person) {
    return {
        id: person.id,
        name: person.name,
        birthDate: (0, date_1.asDateString)(person.birthDate),
        thumbnailPath: person.thumbnailPath,
        isHidden: person.isHidden,
        isFavorite: person.isFavorite,
        color: person.color ?? undefined,
        updatedAt: person.updatedAt,
    };
}
function mapFacesWithoutPerson(face) {
    return {
        id: face.id,
        imageHeight: face.imageHeight,
        imageWidth: face.imageWidth,
        boundingBoxX1: face.boundingBoxX1,
        boundingBoxX2: face.boundingBoxX2,
        boundingBoxY1: face.boundingBoxY1,
        boundingBoxY2: face.boundingBoxY2,
        sourceType: face.sourceType,
    };
}
function mapFaces(face, auth) {
    return {
        id: face.id,
        imageHeight: face.imageHeight,
        imageWidth: face.imageWidth,
        boundingBoxX1: face.boundingBoxX1,
        boundingBoxX2: face.boundingBoxX2,
        boundingBoxY1: face.boundingBoxY1,
        boundingBoxY2: face.boundingBoxY2,
        sourceType: face.sourceType,
        person: face.person?.ownerId === auth.user.id ? mapPerson(face.person) : null,
    };
}
//# sourceMappingURL=person.dto.js.map