"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllJobStatusResponseDto = exports.JobStatusDto = exports.QueueStatusDto = exports.JobCountsDto = exports.JobCreateDto = exports.JobCommandDto = exports.JobIdParamDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class JobIdParamDto {
    id;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, enum: require("../enum").QueueName } };
    }
}
exports.JobIdParamDto = JobIdParamDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsEnum)(enum_1.QueueName),
    (0, swagger_1.ApiProperty)({ type: String, enum: enum_1.QueueName, enumName: 'JobName' }),
    __metadata("design:type", String)
], JobIdParamDto.prototype, "id", void 0);
class JobCommandDto {
    command;
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { command: { required: true, enum: require("../enum").JobCommand }, force: { required: false, type: () => Boolean } };
    }
}
exports.JobCommandDto = JobCommandDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsEnum)(enum_1.JobCommand),
    (0, swagger_1.ApiProperty)({ type: 'string', enum: enum_1.JobCommand, enumName: 'JobCommand' }),
    __metadata("design:type", String)
], JobCommandDto.prototype, "command", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], JobCommandDto.prototype, "force", void 0);
class JobCreateDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, enum: require("../enum").ManualJobName } };
    }
}
exports.JobCreateDto = JobCreateDto;
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.ManualJobName),
    (0, swagger_1.ApiProperty)({ type: 'string', enum: enum_1.ManualJobName, enumName: 'ManualJobName' }),
    __metadata("design:type", String)
], JobCreateDto.prototype, "name", void 0);
class JobCountsDto {
    active;
    completed;
    failed;
    delayed;
    waiting;
    paused;
    static _OPENAPI_METADATA_FACTORY() {
        return { active: { required: true, type: () => Number }, completed: { required: true, type: () => Number }, failed: { required: true, type: () => Number }, delayed: { required: true, type: () => Number }, waiting: { required: true, type: () => Number }, paused: { required: true, type: () => Number } };
    }
}
exports.JobCountsDto = JobCountsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "active", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "completed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "failed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "delayed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "waiting", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], JobCountsDto.prototype, "paused", void 0);
class QueueStatusDto {
    isActive;
    isPaused;
    static _OPENAPI_METADATA_FACTORY() {
        return { isActive: { required: true, type: () => Boolean }, isPaused: { required: true, type: () => Boolean } };
    }
}
exports.QueueStatusDto = QueueStatusDto;
class JobStatusDto {
    jobCounts;
    queueStatus;
    static _OPENAPI_METADATA_FACTORY() {
        return { jobCounts: { required: true, type: () => require("./job.dto").JobCountsDto }, queueStatus: { required: true, type: () => require("./job.dto").QueueStatusDto } };
    }
}
exports.JobStatusDto = JobStatusDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobCountsDto }),
    __metadata("design:type", JobCountsDto)
], JobStatusDto.prototype, "jobCounts", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: QueueStatusDto }),
    __metadata("design:type", QueueStatusDto)
], JobStatusDto.prototype, "queueStatus", void 0);
class AllJobStatusResponseDto {
    [_a = enum_1.QueueName.THUMBNAIL_GENERATION];
    [_b = enum_1.QueueName.METADATA_EXTRACTION];
    [_c = enum_1.QueueName.VIDEO_CONVERSION];
    [_d = enum_1.QueueName.SMART_SEARCH];
    [_e = enum_1.QueueName.STORAGE_TEMPLATE_MIGRATION];
    [_f = enum_1.QueueName.MIGRATION];
    [_g = enum_1.QueueName.BACKGROUND_TASK];
    [_h = enum_1.QueueName.SEARCH];
    [_j = enum_1.QueueName.DUPLICATE_DETECTION];
    [_k = enum_1.QueueName.FACE_DETECTION];
    [_l = enum_1.QueueName.FACIAL_RECOGNITION];
    [_m = enum_1.QueueName.SIDECAR];
    [_o = enum_1.QueueName.LIBRARY];
    [_p = enum_1.QueueName.NOTIFICATION];
    [_q = enum_1.QueueName.BACKUP_DATABASE];
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
exports.AllJobStatusResponseDto = AllJobStatusResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _a, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _b, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _c, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _d, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _e, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _f, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _g, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _h, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _j, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _k, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _l, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _m, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _o, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _p, void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: JobStatusDto }),
    __metadata("design:type", JobStatusDto)
], AllJobStatusResponseDto.prototype, _q, void 0);
//# sourceMappingURL=job.dto.js.map