import { JobCommand, ManualJobName, QueueName } from 'src/enum';
export declare class JobIdParamDto {
    id: QueueName;
}
export declare class JobCommandDto {
    command: JobCommand;
    force?: boolean;
}
export declare class JobCreateDto {
    name: ManualJobName;
}
export declare class JobCountsDto {
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    waiting: number;
    paused: number;
}
export declare class QueueStatusDto {
    isActive: boolean;
    isPaused: boolean;
}
export declare class JobStatusDto {
    jobCounts: JobCountsDto;
    queueStatus: QueueStatusDto;
}
export declare class AllJobStatusResponseDto implements Record<QueueName, JobStatusDto> {
    [QueueName.THUMBNAIL_GENERATION]: JobStatusDto;
    [QueueName.METADATA_EXTRACTION]: JobStatusDto;
    [QueueName.VIDEO_CONVERSION]: JobStatusDto;
    [QueueName.SMART_SEARCH]: JobStatusDto;
    [QueueName.STORAGE_TEMPLATE_MIGRATION]: JobStatusDto;
    [QueueName.MIGRATION]: JobStatusDto;
    [QueueName.BACKGROUND_TASK]: JobStatusDto;
    [QueueName.SEARCH]: JobStatusDto;
    [QueueName.DUPLICATE_DETECTION]: JobStatusDto;
    [QueueName.FACE_DETECTION]: JobStatusDto;
    [QueueName.FACIAL_RECOGNITION]: JobStatusDto;
    [QueueName.SIDECAR]: JobStatusDto;
    [QueueName.LIBRARY]: JobStatusDto;
    [QueueName.NOTIFICATION]: JobStatusDto;
    [QueueName.BACKUP_DATABASE]: JobStatusDto;
}
