"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvDto = void 0;
const openapi = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class EnvDto {
    IMMICH_API_METRICS_PORT;
    IMMICH_BUILD_DATA;
    IMMICH_BUILD;
    IMMICH_BUILD_URL;
    IMMICH_BUILD_IMAGE;
    IMMICH_BUILD_IMAGE_URL;
    IMMICH_CONFIG_FILE;
    IMMICH_ENV;
    IMMICH_HOST;
    IMMICH_IGNORE_MOUNT_CHECK_ERRORS;
    IMMICH_LOG_LEVEL;
    IMMICH_MICROSERVICES_METRICS_PORT;
    IMMICH_PORT;
    IMMICH_REPOSITORY;
    IMMICH_REPOSITORY_URL;
    IMMICH_SOURCE_REF;
    IMMICH_SOURCE_COMMIT;
    IMMICH_SOURCE_URL;
    IMMICH_TELEMETRY_INCLUDE;
    IMMICH_TELEMETRY_EXCLUDE;
    IMMICH_THIRD_PARTY_SOURCE_URL;
    IMMICH_THIRD_PARTY_BUG_FEATURE_URL;
    IMMICH_THIRD_PARTY_DOCUMENTATION_URL;
    IMMICH_THIRD_PARTY_SUPPORT_URL;
    IMMICH_TRUSTED_PROXIES;
    IMMICH_WORKERS_INCLUDE;
    IMMICH_WORKERS_EXCLUDE;
    DB_DATABASE_NAME;
    DB_HOSTNAME;
    DB_PASSWORD;
    DB_PORT;
    DB_SKIP_MIGRATIONS;
    DB_URL;
    DB_USERNAME;
    DB_VECTOR_EXTENSION;
    NO_COLOR;
    REDIS_HOSTNAME;
    REDIS_PORT;
    REDIS_DBINDEX;
    REDIS_USERNAME;
    REDIS_PASSWORD;
    REDIS_SOCKET;
    REDIS_URL;
    static _OPENAPI_METADATA_FACTORY() {
        return { IMMICH_API_METRICS_PORT: { required: false, type: () => Number }, IMMICH_BUILD_DATA: { required: false, type: () => String }, IMMICH_BUILD: { required: false, type: () => String }, IMMICH_BUILD_URL: { required: false, type: () => String }, IMMICH_BUILD_IMAGE: { required: false, type: () => String }, IMMICH_BUILD_IMAGE_URL: { required: false, type: () => String }, IMMICH_CONFIG_FILE: { required: false, type: () => String }, IMMICH_ENV: { required: false, enum: require("../enum").ImmichEnvironment }, IMMICH_HOST: { required: false, type: () => String }, IMMICH_IGNORE_MOUNT_CHECK_ERRORS: { required: false, type: () => Boolean }, IMMICH_LOG_LEVEL: { required: false, enum: require("../enum").LogLevel }, IMMICH_MICROSERVICES_METRICS_PORT: { required: false, type: () => Number }, IMMICH_PORT: { required: false, type: () => Number }, IMMICH_REPOSITORY: { required: false, type: () => String }, IMMICH_REPOSITORY_URL: { required: false, type: () => String }, IMMICH_SOURCE_REF: { required: false, type: () => String }, IMMICH_SOURCE_COMMIT: { required: false, type: () => String }, IMMICH_SOURCE_URL: { required: false, type: () => String }, IMMICH_TELEMETRY_INCLUDE: { required: false, type: () => String }, IMMICH_TELEMETRY_EXCLUDE: { required: false, type: () => String }, IMMICH_THIRD_PARTY_SOURCE_URL: { required: false, type: () => String }, IMMICH_THIRD_PARTY_BUG_FEATURE_URL: { required: false, type: () => String }, IMMICH_THIRD_PARTY_DOCUMENTATION_URL: { required: false, type: () => String }, IMMICH_THIRD_PARTY_SUPPORT_URL: { required: false, type: () => String }, IMMICH_TRUSTED_PROXIES: { required: false, type: () => [String] }, IMMICH_WORKERS_INCLUDE: { required: false, type: () => String }, IMMICH_WORKERS_EXCLUDE: { required: false, type: () => String }, DB_DATABASE_NAME: { required: false, type: () => String }, DB_HOSTNAME: { required: false, type: () => String }, DB_PASSWORD: { required: false, type: () => String }, DB_PORT: { required: false, type: () => Number }, DB_SKIP_MIGRATIONS: { required: false, type: () => Boolean }, DB_URL: { required: false, type: () => String }, DB_USERNAME: { required: false, type: () => String }, DB_VECTOR_EXTENSION: { required: false, type: () => Object }, NO_COLOR: { required: false, type: () => String }, REDIS_HOSTNAME: { required: false, type: () => String }, REDIS_PORT: { required: false, type: () => Number }, REDIS_DBINDEX: { required: false, type: () => Number }, REDIS_USERNAME: { required: false, type: () => String }, REDIS_PASSWORD: { required: false, type: () => String }, REDIS_SOCKET: { required: false, type: () => String }, REDIS_URL: { required: false, type: () => String } };
    }
}
exports.EnvDto = EnvDto;
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "IMMICH_API_METRICS_PORT", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_BUILD_DATA", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_BUILD", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_BUILD_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_BUILD_IMAGE", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_BUILD_IMAGE_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_CONFIG_FILE", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.ImmichEnvironment),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_ENV", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_HOST", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], EnvDto.prototype, "IMMICH_IGNORE_MOUNT_CHECK_ERRORS", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.LogLevel),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_LOG_LEVEL", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "IMMICH_MICROSERVICES_METRICS_PORT", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "IMMICH_PORT", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_REPOSITORY", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_REPOSITORY_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_SOURCE_REF", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_SOURCE_COMMIT", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_SOURCE_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_TELEMETRY_INCLUDE", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_TELEMETRY_EXCLUDE", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_THIRD_PARTY_SOURCE_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_THIRD_PARTY_BUG_FEATURE_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_THIRD_PARTY_DOCUMENTATION_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_THIRD_PARTY_SUPPORT_URL", void 0);
__decorate([
    (0, validation_1.IsIPRange)({ requireCIDR: false }, { each: true }),
    (0, class_transformer_1.Transform)(({ value }) => value && typeof value === 'string'
        ? value
            .split(',')
            .map((value) => value.trim())
            .filter(Boolean)
        : value),
    (0, validation_1.Optional)(),
    __metadata("design:type", Array)
], EnvDto.prototype, "IMMICH_TRUSTED_PROXIES", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_WORKERS_INCLUDE", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "IMMICH_WORKERS_EXCLUDE", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_DATABASE_NAME", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_HOSTNAME", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_PASSWORD", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "DB_PORT", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], EnvDto.prototype, "DB_SKIP_MIGRATIONS", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_URL", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_USERNAME", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(['pgvector', 'pgvecto.rs']),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "DB_VECTOR_EXTENSION", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "NO_COLOR", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "REDIS_HOSTNAME", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "REDIS_PORT", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, validation_1.Optional)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], EnvDto.prototype, "REDIS_DBINDEX", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "REDIS_USERNAME", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "REDIS_PASSWORD", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "REDIS_SOCKET", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], EnvDto.prototype, "REDIS_URL", void 0);
//# sourceMappingURL=env.dto.js.map