"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthAuthorizeResponseDto = exports.OAuthConfigDto = exports.OAuthCallbackDto = exports.ValidateAccessTokenResponseDto = exports.ChangePasswordDto = exports.SignUpDto = exports.LogoutResponseDto = exports.LoginResponseDto = exports.LoginCredentialDto = exports.AuthDto = void 0;
exports.mapLoginResponse = mapLoginResponse;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class AuthDto {
    user;
    apiKey;
    sharedLink;
    session;
    static _OPENAPI_METADATA_FACTORY() {
        return { user: { required: true, type: () => Object }, apiKey: { required: false, type: () => Object }, sharedLink: { required: false, type: () => Object }, session: { required: false, type: () => Object } };
    }
}
exports.AuthDto = AuthDto;
class LoginCredentialDto {
    email;
    password;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: true, type: () => String, format: "email" }, password: { required: true, type: () => String } };
    }
}
exports.LoginCredentialDto = LoginCredentialDto;
__decorate([
    (0, class_validator_1.IsEmail)({ require_tld: false }),
    (0, class_transformer_1.Transform)(validation_1.toEmail),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ example: 'testuser@email.com' }),
    __metadata("design:type", String)
], LoginCredentialDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ example: 'password' }),
    __metadata("design:type", String)
], LoginCredentialDto.prototype, "password", void 0);
class LoginResponseDto {
    accessToken;
    userId;
    userEmail;
    name;
    profileImagePath;
    isAdmin;
    shouldChangePassword;
    static _OPENAPI_METADATA_FACTORY() {
        return { accessToken: { required: true, type: () => String }, userId: { required: true, type: () => String }, userEmail: { required: true, type: () => String }, name: { required: true, type: () => String }, profileImagePath: { required: true, type: () => String }, isAdmin: { required: true, type: () => Boolean }, shouldChangePassword: { required: true, type: () => Boolean } };
    }
}
exports.LoginResponseDto = LoginResponseDto;
function mapLoginResponse(entity, accessToken) {
    return {
        accessToken,
        userId: entity.id,
        userEmail: entity.email,
        name: entity.name,
        isAdmin: entity.isAdmin,
        profileImagePath: entity.profileImagePath,
        shouldChangePassword: entity.shouldChangePassword,
    };
}
class LogoutResponseDto {
    successful;
    redirectUri;
    static _OPENAPI_METADATA_FACTORY() {
        return { successful: { required: true, type: () => Boolean }, redirectUri: { required: true, type: () => String } };
    }
}
exports.LogoutResponseDto = LogoutResponseDto;
class SignUpDto extends LoginCredentialDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String } };
    }
}
exports.SignUpDto = SignUpDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ example: 'Admin' }),
    __metadata("design:type", String)
], SignUpDto.prototype, "name", void 0);
class ChangePasswordDto {
    password;
    newPassword;
    static _OPENAPI_METADATA_FACTORY() {
        return { password: { required: true, type: () => String }, newPassword: { required: true, type: () => String, minLength: 8 } };
    }
}
exports.ChangePasswordDto = ChangePasswordDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, swagger_1.ApiProperty)({ example: 'password' }),
    __metadata("design:type", String)
], ChangePasswordDto.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MinLength)(8),
    (0, swagger_1.ApiProperty)({ example: 'password' }),
    __metadata("design:type", String)
], ChangePasswordDto.prototype, "newPassword", void 0);
class ValidateAccessTokenResponseDto {
    authStatus;
    static _OPENAPI_METADATA_FACTORY() {
        return { authStatus: { required: true, type: () => Boolean } };
    }
}
exports.ValidateAccessTokenResponseDto = ValidateAccessTokenResponseDto;
class OAuthCallbackDto {
    url;
    state;
    codeVerifier;
    static _OPENAPI_METADATA_FACTORY() {
        return { url: { required: true, type: () => String }, state: { required: false, type: () => String }, codeVerifier: { required: false, type: () => String } };
    }
}
exports.OAuthCallbackDto = OAuthCallbackDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "url", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "state", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "codeVerifier", void 0);
class OAuthConfigDto {
    redirectUri;
    state;
    codeChallenge;
    static _OPENAPI_METADATA_FACTORY() {
        return { redirectUri: { required: true, type: () => String }, state: { required: false, type: () => String }, codeChallenge: { required: false, type: () => String } };
    }
}
exports.OAuthConfigDto = OAuthConfigDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "redirectUri", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "state", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "codeChallenge", void 0);
class OAuthAuthorizeResponseDto {
    url;
    static _OPENAPI_METADATA_FACTORY() {
        return { url: { required: true, type: () => String } };
    }
}
exports.OAuthAuthorizeResponseDto = OAuthAuthorizeResponseDto;
//# sourceMappingURL=auth.dto.js.map