"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileReportItemDto = exports.FileReportFixDto = exports.FileChecksumResponseDto = exports.FileChecksumDto = exports.FileReportDto = exports.AuditDeletesResponseDto = exports.PathEntityType = exports.AuditDeletesDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
const PathEnum = Object.values({ ...enum_1.AssetPathType, ...enum_1.PersonPathType, ...enum_1.UserPathType });
class AuditDeletesDto {
    after;
    entityType;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { after: { required: true, type: () => Date }, entityType: { required: true, enum: require("../enum").EntityType }, userId: { required: false, type: () => String, format: "uuid" } };
    }
}
exports.AuditDeletesDto = AuditDeletesDto;
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AuditDeletesDto.prototype, "after", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: enum_1.EntityType, enumName: 'EntityType' }),
    (0, class_validator_1.IsEnum)(enum_1.EntityType),
    __metadata("design:type", String)
], AuditDeletesDto.prototype, "entityType", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsUUID)('4'),
    (0, swagger_1.ApiProperty)({ format: 'uuid' }),
    __metadata("design:type", String)
], AuditDeletesDto.prototype, "userId", void 0);
var PathEntityType;
(function (PathEntityType) {
    PathEntityType["ASSET"] = "asset";
    PathEntityType["PERSON"] = "person";
    PathEntityType["USER"] = "user";
})(PathEntityType || (exports.PathEntityType = PathEntityType = {}));
class AuditDeletesResponseDto {
    needsFullSync;
    ids;
    static _OPENAPI_METADATA_FACTORY() {
        return { needsFullSync: { required: true, type: () => Boolean }, ids: { required: true, type: () => [String] } };
    }
}
exports.AuditDeletesResponseDto = AuditDeletesResponseDto;
class FileReportDto {
    orphans;
    extras;
    static _OPENAPI_METADATA_FACTORY() {
        return { orphans: { required: true, type: () => [require("./audit.dto").FileReportItemDto] }, extras: { required: true, type: () => [String] } };
    }
}
exports.FileReportDto = FileReportDto;
class FileChecksumDto {
    filenames;
    static _OPENAPI_METADATA_FACTORY() {
        return { filenames: { required: true, type: () => [String] } };
    }
}
exports.FileChecksumDto = FileChecksumDto;
__decorate([
    (0, class_validator_1.IsString)({ each: true }),
    __metadata("design:type", Array)
], FileChecksumDto.prototype, "filenames", void 0);
class FileChecksumResponseDto {
    filename;
    checksum;
    static _OPENAPI_METADATA_FACTORY() {
        return { filename: { required: true, type: () => String }, checksum: { required: true, type: () => String } };
    }
}
exports.FileChecksumResponseDto = FileChecksumResponseDto;
class FileReportFixDto {
    items;
    static _OPENAPI_METADATA_FACTORY() {
        return { items: { required: true, type: () => [require("./audit.dto").FileReportItemDto] } };
    }
}
exports.FileReportFixDto = FileReportFixDto;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => FileReportItemDto),
    __metadata("design:type", Array)
], FileReportFixDto.prototype, "items", void 0);
class FileReportItemDto {
    entityId;
    entityType;
    pathType;
    pathValue;
    checksum;
    static _OPENAPI_METADATA_FACTORY() {
        return { entityId: { required: true, type: () => String }, entityType: { required: true, enum: require("./audit.dto").PathEntityType }, pathType: { required: true, type: () => Object }, pathValue: { required: true, type: () => String }, checksum: { required: false, type: () => String } };
    }
}
exports.FileReportItemDto = FileReportItemDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], FileReportItemDto.prototype, "entityId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enumName: 'PathEntityType', enum: PathEntityType }),
    (0, class_validator_1.IsEnum)(PathEntityType),
    __metadata("design:type", String)
], FileReportItemDto.prototype, "entityType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enumName: 'PathType', enum: PathEnum }),
    (0, class_validator_1.IsEnum)(PathEnum),
    __metadata("design:type", String)
], FileReportItemDto.prototype, "pathType", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], FileReportItemDto.prototype, "pathValue", void 0);
//# sourceMappingURL=audit.dto.js.map