import { EntityType, PathType } from 'src/enum';
export declare class AuditDeletesDto {
    after: Date;
    entityType: EntityType;
    userId?: string;
}
export declare enum PathEntityType {
    ASSET = "asset",
    PERSON = "person",
    USER = "user"
}
export declare class AuditDeletesResponseDto {
    needsFullSync: boolean;
    ids: string[];
}
export declare class FileReportDto {
    orphans: FileReportItemDto[];
    extras: string[];
}
export declare class FileChecksumDto {
    filenames: string[];
}
export declare class FileChecksumResponseDto {
    filename: string;
    checksum: string;
}
export declare class FileReportFixDto {
    items: FileReportItemDto[];
}
export declare class FileReportItemDto {
    entityId: string;
    entityType: PathEntityType;
    pathType: PathType;
    pathValue: string;
    checksum?: string;
}
