"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapStats = exports.AssetStatsResponseDto = exports.AssetStatsDto = exports.AssetJobsDto = exports.AssetJobName = exports.AssetIdsDto = exports.AssetBulkDeleteDto = exports.RandomAssetsDto = exports.UpdateAssetDto = exports.AssetBulkUpdateDto = exports.UpdateAssetBase = exports.DeviceIdDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const asset_ids_response_dto_1 = require("./asset-ids.response.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class DeviceIdDto {
    deviceId;
    static _OPENAPI_METADATA_FACTORY() {
        return { deviceId: { required: true, type: () => String } };
    }
}
exports.DeviceIdDto = DeviceIdDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], DeviceIdDto.prototype, "deviceId", void 0);
const hasGPS = (o) => o.latitude !== undefined || o.longitude !== undefined;
const ValidateGPS = () => (0, class_validator_1.ValidateIf)(hasGPS);
class UpdateAssetBase {
    isFavorite;
    isArchived;
    dateTimeOriginal;
    latitude;
    longitude;
    rating;
    static _OPENAPI_METADATA_FACTORY() {
        return { isFavorite: { required: false, type: () => Boolean }, isArchived: { required: false, type: () => Boolean }, dateTimeOriginal: { required: false, type: () => String }, latitude: { required: false, type: () => Number }, longitude: { required: false, type: () => Number }, rating: { required: false, type: () => Number, minimum: -1, maximum: 5 } };
    }
}
exports.UpdateAssetBase = UpdateAssetBase;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], UpdateAssetBase.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], UpdateAssetBase.prototype, "isArchived", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], UpdateAssetBase.prototype, "dateTimeOriginal", void 0);
__decorate([
    ValidateGPS(),
    (0, class_validator_1.IsLatitude)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "latitude", void 0);
__decorate([
    ValidateGPS(),
    (0, class_validator_1.IsLongitude)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "longitude", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Max)(5),
    (0, class_validator_1.Min)(-1),
    __metadata("design:type", Number)
], UpdateAssetBase.prototype, "rating", void 0);
class AssetBulkUpdateDto extends UpdateAssetBase {
    ids;
    duplicateId;
    static _OPENAPI_METADATA_FACTORY() {
        return { ids: { required: true, type: () => [String] }, duplicateId: { required: false, type: () => String, nullable: true } };
    }
}
exports.AssetBulkUpdateDto = AssetBulkUpdateDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], AssetBulkUpdateDto.prototype, "ids", void 0);
__decorate([
    (0, validation_1.Optional)(),
    __metadata("design:type", Object)
], AssetBulkUpdateDto.prototype, "duplicateId", void 0);
class UpdateAssetDto extends UpdateAssetBase {
    description;
    livePhotoVideoId;
    static _OPENAPI_METADATA_FACTORY() {
        return { description: { required: false, type: () => String }, livePhotoVideoId: { required: false, type: () => String, nullable: true } };
    }
}
exports.UpdateAssetDto = UpdateAssetDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateAssetDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, nullable: true }),
    __metadata("design:type", Object)
], UpdateAssetDto.prototype, "livePhotoVideoId", void 0);
class RandomAssetsDto {
    count;
    static _OPENAPI_METADATA_FACTORY() {
        return { count: { required: false, type: () => Number, minimum: 1 } };
    }
}
exports.RandomAssetsDto = RandomAssetsDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], RandomAssetsDto.prototype, "count", void 0);
class AssetBulkDeleteDto extends asset_ids_response_dto_1.BulkIdsDto {
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { force: { required: false, type: () => Boolean } };
    }
}
exports.AssetBulkDeleteDto = AssetBulkDeleteDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetBulkDeleteDto.prototype, "force", void 0);
class AssetIdsDto {
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetIds: { required: true, type: () => [String] } };
    }
}
exports.AssetIdsDto = AssetIdsDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], AssetIdsDto.prototype, "assetIds", void 0);
var AssetJobName;
(function (AssetJobName) {
    AssetJobName["REFRESH_FACES"] = "refresh-faces";
    AssetJobName["REFRESH_METADATA"] = "refresh-metadata";
    AssetJobName["REGENERATE_THUMBNAIL"] = "regenerate-thumbnail";
    AssetJobName["TRANSCODE_VIDEO"] = "transcode-video";
})(AssetJobName || (exports.AssetJobName = AssetJobName = {}));
class AssetJobsDto extends AssetIdsDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, enum: require("./asset.dto").AssetJobName } };
    }
}
exports.AssetJobsDto = AssetJobsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enumName: 'AssetJobName', enum: AssetJobName }),
    (0, class_validator_1.IsEnum)(AssetJobName),
    __metadata("design:type", String)
], AssetJobsDto.prototype, "name", void 0);
class AssetStatsDto {
    isArchived;
    isFavorite;
    isTrashed;
    static _OPENAPI_METADATA_FACTORY() {
        return { isArchived: { required: false, type: () => Boolean }, isFavorite: { required: false, type: () => Boolean }, isTrashed: { required: false, type: () => Boolean } };
    }
}
exports.AssetStatsDto = AssetStatsDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetStatsDto.prototype, "isArchived", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetStatsDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetStatsDto.prototype, "isTrashed", void 0);
class AssetStatsResponseDto {
    images;
    videos;
    total;
    static _OPENAPI_METADATA_FACTORY() {
        return { images: { required: true, type: () => Number }, videos: { required: true, type: () => Number }, total: { required: true, type: () => Number } };
    }
}
exports.AssetStatsResponseDto = AssetStatsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "images", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "videos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetStatsResponseDto.prototype, "total", void 0);
const mapStats = (stats) => {
    return {
        images: stats[enum_1.AssetType.IMAGE],
        videos: stats[enum_1.AssetType.VIDEO],
        total: Object.values(stats).reduce((total, value) => total + value, 0),
    };
};
exports.mapStats = mapStats;
//# sourceMappingURL=asset.dto.js.map