import { BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AssetStats } from 'src/repositories/asset.repository';
export declare class DeviceIdDto {
    deviceId: string;
}
export declare class UpdateAssetBase {
    isFavorite?: boolean;
    isArchived?: boolean;
    dateTimeOriginal?: string;
    latitude?: number;
    longitude?: number;
    rating?: number;
}
export declare class AssetBulkUpdateDto extends UpdateAssetBase {
    ids: string[];
    duplicateId?: string | null;
}
export declare class UpdateAssetDto extends UpdateAssetBase {
    description?: string;
    livePhotoVideoId?: string | null;
}
export declare class RandomAssetsDto {
    count?: number;
}
export declare class AssetBulkDeleteDto extends BulkIdsDto {
    force?: boolean;
}
export declare class AssetIdsDto {
    assetIds: string[];
}
export declare enum AssetJobName {
    REFRESH_FACES = "refresh-faces",
    REFRESH_METADATA = "refresh-metadata",
    REGENERATE_THUMBNAIL = "regenerate-thumbnail",
    TRANSCODE_VIDEO = "transcode-video"
}
export declare class AssetJobsDto extends AssetIdsDto {
    name: AssetJobName;
}
export declare class AssetStatsDto {
    isArchived?: boolean;
    isFavorite?: boolean;
    isTrashed?: boolean;
}
export declare class AssetStatsResponseDto {
    images: number;
    videos: number;
    total: number;
}
export declare const mapStats: (stats: AssetStats) => AssetStatsResponseDto;
