"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryLaneResponseDto = exports.hexOrBufferToBase64 = exports.AssetStackResponseDto = exports.AssetResponseDto = exports.SanitizedAssetResponseDto = void 0;
exports.mapAsset = mapAsset;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const exif_dto_1 = require("./exif.dto");
const person_dto_1 = require("./person.dto");
const tag_dto_1 = require("./tag.dto");
const user_dto_1 = require("./user.dto");
const enum_1 = require("../enum");
const mime_types_1 = require("../utils/mime-types");
class SanitizedAssetResponseDto {
    id;
    type;
    thumbhash;
    originalMimeType;
    localDateTime;
    duration;
    livePhotoVideoId;
    hasMetadata;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, type: { required: true, enum: require("../enum").AssetType }, thumbhash: { required: true, type: () => String, nullable: true }, originalMimeType: { required: false, type: () => String }, localDateTime: { required: true, type: () => Date }, duration: { required: true, type: () => String }, livePhotoVideoId: { required: false, type: () => String, nullable: true }, hasMetadata: { required: true, type: () => Boolean } };
    }
}
exports.SanitizedAssetResponseDto = SanitizedAssetResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enumName: 'AssetTypeEnum', enum: enum_1.AssetType }),
    __metadata("design:type", String)
], SanitizedAssetResponseDto.prototype, "type", void 0);
class AssetResponseDto extends SanitizedAssetResponseDto {
    deviceAssetId;
    deviceId;
    ownerId;
    owner;
    libraryId;
    originalPath;
    originalFileName;
    fileCreatedAt;
    fileModifiedAt;
    updatedAt;
    isFavorite;
    isArchived;
    isTrashed;
    isOffline;
    exifInfo;
    tags;
    people;
    unassignedFaces;
    checksum;
    stack;
    duplicateId;
    resized;
    static _OPENAPI_METADATA_FACTORY() {
        return { deviceAssetId: { required: true, type: () => String }, deviceId: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, owner: { required: false, type: () => require("./user.dto").UserResponseDto }, libraryId: { required: false, type: () => String, nullable: true }, originalPath: { required: true, type: () => String }, originalFileName: { required: true, type: () => String }, fileCreatedAt: { required: true, type: () => Date }, fileModifiedAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, isFavorite: { required: true, type: () => Boolean }, isArchived: { required: true, type: () => Boolean }, isTrashed: { required: true, type: () => Boolean }, isOffline: { required: true, type: () => Boolean }, exifInfo: { required: false, type: () => require("./exif.dto").ExifResponseDto }, tags: { required: false, type: () => [require("./tag.dto").TagResponseDto] }, people: { required: false, type: () => [require("./person.dto").PersonWithFacesResponseDto] }, unassignedFaces: { required: false, type: () => [require("./person.dto").AssetFaceWithoutPersonResponseDto] }, checksum: { required: true, type: () => String, description: "base64 encoded sha1 hash" }, stack: { required: false, type: () => require("./asset-response.dto").AssetStackResponseDto, nullable: true }, duplicateId: { required: false, type: () => String, nullable: true }, resized: { required: false, type: () => Boolean } };
    }
}
exports.AssetResponseDto = AssetResponseDto;
__decorate([
    (0, decorators_1.PropertyLifecycle)({ deprecatedAt: 'v1.106.0' }),
    __metadata("design:type", Object)
], AssetResponseDto.prototype, "libraryId", void 0);
__decorate([
    (0, decorators_1.PropertyLifecycle)({ deprecatedAt: 'v1.113.0' }),
    __metadata("design:type", Boolean)
], AssetResponseDto.prototype, "resized", void 0);
class AssetStackResponseDto {
    id;
    primaryAssetId;
    assetCount;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, primaryAssetId: { required: true, type: () => String }, assetCount: { required: true, type: () => Number } };
    }
}
exports.AssetStackResponseDto = AssetStackResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], AssetStackResponseDto.prototype, "assetCount", void 0);
const peopleWithFaces = (faces) => {
    const result = [];
    if (faces) {
        for (const face of faces) {
            if (face.person) {
                const existingPersonEntry = result.find((item) => item.id === face.person.id);
                if (existingPersonEntry) {
                    existingPersonEntry.faces.push(face);
                }
                else {
                    result.push({ ...(0, person_dto_1.mapPerson)(face.person), faces: [(0, person_dto_1.mapFacesWithoutPerson)(face)] });
                }
            }
        }
    }
    return result;
};
const mapStack = (entity) => {
    if (!entity.stack) {
        return null;
    }
    return {
        id: entity.stack.id,
        primaryAssetId: entity.stack.primaryAssetId,
        assetCount: entity.stack.assetCount ?? entity.stack.assets.length + 1,
    };
};
const hexOrBufferToBase64 = (encoded) => {
    if (typeof encoded === 'string') {
        return Buffer.from(encoded.slice(2), 'hex').toString('base64');
    }
    return encoded.toString('base64');
};
exports.hexOrBufferToBase64 = hexOrBufferToBase64;
function mapAsset(entity, options = {}) {
    const { stripMetadata = false, withStack = false } = options;
    if (stripMetadata) {
        const sanitizedAssetResponse = {
            id: entity.id,
            type: entity.type,
            originalMimeType: mime_types_1.mimeTypes.lookup(entity.originalFileName),
            thumbhash: entity.thumbhash ? (0, exports.hexOrBufferToBase64)(entity.thumbhash) : null,
            localDateTime: entity.localDateTime,
            duration: entity.duration ?? '0:00:00.00000',
            livePhotoVideoId: entity.livePhotoVideoId,
            hasMetadata: false,
        };
        return sanitizedAssetResponse;
    }
    return {
        id: entity.id,
        deviceAssetId: entity.deviceAssetId,
        ownerId: entity.ownerId,
        owner: entity.owner ? (0, user_dto_1.mapUser)(entity.owner) : undefined,
        deviceId: entity.deviceId,
        libraryId: entity.libraryId,
        type: entity.type,
        originalPath: entity.originalPath,
        originalFileName: entity.originalFileName,
        originalMimeType: mime_types_1.mimeTypes.lookup(entity.originalFileName),
        thumbhash: entity.thumbhash ? (0, exports.hexOrBufferToBase64)(entity.thumbhash) : null,
        fileCreatedAt: entity.fileCreatedAt,
        fileModifiedAt: entity.fileModifiedAt,
        localDateTime: entity.localDateTime,
        updatedAt: entity.updatedAt,
        isFavorite: options.auth?.user.id === entity.ownerId ? entity.isFavorite : false,
        isArchived: entity.isArchived,
        isTrashed: !!entity.deletedAt,
        duration: entity.duration ?? '0:00:00.00000',
        exifInfo: entity.exifInfo ? (0, exif_dto_1.mapExif)(entity.exifInfo) : undefined,
        livePhotoVideoId: entity.livePhotoVideoId,
        tags: entity.tags?.map((tag) => (0, tag_dto_1.mapTag)(tag)),
        people: peopleWithFaces(entity.faces),
        unassignedFaces: entity.faces?.filter((face) => !face.person).map((a) => (0, person_dto_1.mapFacesWithoutPerson)(a)),
        checksum: (0, exports.hexOrBufferToBase64)(entity.checksum),
        stack: withStack ? mapStack(entity) : undefined,
        isOffline: entity.isOffline,
        hasMetadata: true,
        duplicateId: entity.duplicateId,
        resized: true,
    };
}
class MemoryLaneResponseDto {
    yearsAgo;
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { yearsAgo: { required: true, type: () => Number }, assets: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] } };
    }
}
exports.MemoryLaneResponseDto = MemoryLaneResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], MemoryLaneResponseDto.prototype, "yearsAgo", void 0);
//# sourceMappingURL=asset-response.dto.js.map