import { Selectable } from 'kysely';
import { AssetFace, AssetFile, Exif, Stack, Tag, User } from 'src/database';
import { AuthDto } from 'src/dtos/auth.dto';
import { ExifResponseDto } from 'src/dtos/exif.dto';
import { AssetFaceWithoutPersonResponseDto, PersonWithFacesResponseDto } from 'src/dtos/person.dto';
import { TagResponseDto } from 'src/dtos/tag.dto';
import { UserResponseDto } from 'src/dtos/user.dto';
import { AssetStatus, AssetType } from 'src/enum';
export declare class SanitizedAssetResponseDto {
    id: string;
    type: AssetType;
    thumbhash: string | null;
    originalMimeType?: string;
    localDateTime: Date;
    duration: string;
    livePhotoVideoId?: string | null;
    hasMetadata: boolean;
}
export declare class AssetResponseDto extends SanitizedAssetResponseDto {
    deviceAssetId: string;
    deviceId: string;
    ownerId: string;
    owner?: UserResponseDto;
    libraryId?: string | null;
    originalPath: string;
    originalFileName: string;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    updatedAt: Date;
    isFavorite: boolean;
    isArchived: boolean;
    isTrashed: boolean;
    isOffline: boolean;
    exifInfo?: ExifResponseDto;
    tags?: TagResponseDto[];
    people?: PersonWithFacesResponseDto[];
    unassignedFaces?: AssetFaceWithoutPersonResponseDto[];
    checksum: string;
    stack?: AssetStackResponseDto | null;
    duplicateId?: string | null;
    resized?: boolean;
}
export type MapAsset = {
    createdAt: Date;
    updatedAt: Date;
    deletedAt: Date | null;
    id: string;
    updateId: string;
    status: AssetStatus;
    checksum: Buffer<ArrayBufferLike>;
    deviceAssetId: string;
    deviceId: string;
    duplicateId: string | null;
    duration: string | null;
    encodedVideoPath: string | null;
    exifInfo?: Selectable<Exif> | null;
    faces?: AssetFace[];
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    files?: AssetFile[];
    isArchived: boolean;
    isExternal: boolean;
    isFavorite: boolean;
    isOffline: boolean;
    isVisible: boolean;
    libraryId: string | null;
    livePhotoVideoId: string | null;
    localDateTime: Date;
    originalFileName: string;
    originalPath: string;
    owner?: User | null;
    ownerId: string;
    sidecarPath: string | null;
    stack?: Stack | null;
    stackId: string | null;
    tags?: Tag[];
    thumbhash: Buffer<ArrayBufferLike> | null;
    type: AssetType;
};
export declare class AssetStackResponseDto {
    id: string;
    primaryAssetId: string;
    assetCount: number;
}
export type AssetMapOptions = {
    stripMetadata?: boolean;
    withStack?: boolean;
    auth?: AuthDto;
};
export declare const hexOrBufferToBase64: (encoded: string | Buffer) => string;
export declare function mapAsset(entity: MapAsset, options?: AssetMapOptions): AssetResponseDto;
export declare class MemoryLaneResponseDto {
    yearsAgo: number;
    assets: AssetResponseDto[];
}
