"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckExistingAssetsDto = exports.AssetBulkUploadCheckDto = exports.AssetBulkUploadCheckItem = exports.AssetMediaReplaceDto = exports.AssetMediaCreateDto = exports.UploadFieldName = exports.AssetMediaOptionsDto = exports.AssetMediaSize = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
var AssetMediaSize;
(function (AssetMediaSize) {
    AssetMediaSize["FULLSIZE"] = "fullsize";
    AssetMediaSize["PREVIEW"] = "preview";
    AssetMediaSize["THUMBNAIL"] = "thumbnail";
})(AssetMediaSize || (exports.AssetMediaSize = AssetMediaSize = {}));
class AssetMediaOptionsDto {
    size;
    static _OPENAPI_METADATA_FACTORY() {
        return { size: { required: false, enum: require("./asset-media.dto").AssetMediaSize } };
    }
}
exports.AssetMediaOptionsDto = AssetMediaOptionsDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsEnum)(AssetMediaSize),
    (0, swagger_1.ApiProperty)({ enumName: 'AssetMediaSize', enum: AssetMediaSize }),
    __metadata("design:type", String)
], AssetMediaOptionsDto.prototype, "size", void 0);
var UploadFieldName;
(function (UploadFieldName) {
    UploadFieldName["ASSET_DATA"] = "assetData";
    UploadFieldName["SIDECAR_DATA"] = "sidecarData";
    UploadFieldName["PROFILE_DATA"] = "file";
})(UploadFieldName || (exports.UploadFieldName = UploadFieldName = {}));
class AssetMediaBase {
    deviceAssetId;
    deviceId;
    fileCreatedAt;
    fileModifiedAt;
    duration;
    [_a = UploadFieldName.ASSET_DATA];
    static _OPENAPI_METADATA_FACTORY() {
        return { deviceAssetId: { required: true, type: () => String }, deviceId: { required: true, type: () => String }, fileCreatedAt: { required: true, type: () => Date }, fileModifiedAt: { required: true, type: () => Date }, duration: { required: false, type: () => String } };
    }
}
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], AssetMediaBase.prototype, "deviceAssetId", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], AssetMediaBase.prototype, "deviceId", void 0);
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetMediaBase.prototype, "fileCreatedAt", void 0);
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], AssetMediaBase.prototype, "fileModifiedAt", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], AssetMediaBase.prototype, "duration", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', format: 'binary' }),
    __metadata("design:type", Object)
], AssetMediaBase.prototype, _a, void 0);
class AssetMediaCreateDto extends AssetMediaBase {
    isFavorite;
    isArchived;
    isVisible;
    livePhotoVideoId;
    [_b = UploadFieldName.SIDECAR_DATA];
    static _OPENAPI_METADATA_FACTORY() {
        return { isFavorite: { required: false, type: () => Boolean }, isArchived: { required: false, type: () => Boolean }, isVisible: { required: false, type: () => Boolean }, livePhotoVideoId: { required: false, type: () => String } };
    }
}
exports.AssetMediaCreateDto = AssetMediaCreateDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetMediaCreateDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetMediaCreateDto.prototype, "isArchived", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], AssetMediaCreateDto.prototype, "isVisible", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], AssetMediaCreateDto.prototype, "livePhotoVideoId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', format: 'binary', required: false }),
    __metadata("design:type", Object)
], AssetMediaCreateDto.prototype, _b, void 0);
class AssetMediaReplaceDto extends AssetMediaBase {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
exports.AssetMediaReplaceDto = AssetMediaReplaceDto;
class AssetBulkUploadCheckItem {
    id;
    checksum;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, checksum: { required: true, type: () => String, description: "base64 or hex encoded sha1 hash" } };
    }
}
exports.AssetBulkUploadCheckItem = AssetBulkUploadCheckItem;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], AssetBulkUploadCheckItem.prototype, "id", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], AssetBulkUploadCheckItem.prototype, "checksum", void 0);
class AssetBulkUploadCheckDto {
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { assets: { required: true, type: () => [require("./asset-media.dto").AssetBulkUploadCheckItem] } };
    }
}
exports.AssetBulkUploadCheckDto = AssetBulkUploadCheckDto;
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AssetBulkUploadCheckItem),
    __metadata("design:type", Array)
], AssetBulkUploadCheckDto.prototype, "assets", void 0);
class CheckExistingAssetsDto {
    deviceAssetIds;
    deviceId;
    static _OPENAPI_METADATA_FACTORY() {
        return { deviceAssetIds: { required: true, type: () => [String], minItems: 1 }, deviceId: { required: true, type: () => String } };
    }
}
exports.CheckExistingAssetsDto = CheckExistingAssetsDto;
__decorate([
    (0, class_validator_1.ArrayNotEmpty)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    __metadata("design:type", Array)
], CheckExistingAssetsDto.prototype, "deviceAssetIds", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], CheckExistingAssetsDto.prototype, "deviceId", void 0);
//# sourceMappingURL=asset-media.dto.js.map