export declare enum AssetMediaSize {
    FULLSIZE = "fullsize",
    PREVIEW = "preview",
    THUMBNAIL = "thumbnail"
}
export declare class AssetMediaOptionsDto {
    size?: AssetMediaSize;
}
export declare enum UploadFieldName {
    ASSET_DATA = "assetData",
    SIDECAR_DATA = "sidecarData",
    PROFILE_DATA = "file"
}
declare class AssetMediaBase {
    deviceAssetId: string;
    deviceId: string;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    duration?: string;
    [UploadFieldName.ASSET_DATA]: any;
}
export declare class AssetMediaCreateDto extends AssetMediaBase {
    isFavorite?: boolean;
    isArchived?: boolean;
    isVisible?: boolean;
    livePhotoVideoId?: string;
    [UploadFieldName.SIDECAR_DATA]?: any;
}
export declare class AssetMediaReplaceDto extends AssetMediaBase {
}
export declare class AssetBulkUploadCheckItem {
    id: string;
    checksum: string;
}
export declare class AssetBulkUploadCheckDto {
    assets: AssetBulkUploadCheckItem[];
}
export declare class CheckExistingAssetsDto {
    deviceAssetIds: string[];
    deviceId: string;
}
export {};
