"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.APIKeyResponseDto = exports.APIKeyCreateResponseDto = exports.APIKeyUpdateDto = exports.APIKeyCreateDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class APIKeyCreateDto {
    name;
    permissions;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: false, type: () => String }, permissions: { required: true, enum: require("../enum").Permission, isArray: true, minItems: 1 } };
    }
}
exports.APIKeyCreateDto = APIKeyCreateDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], APIKeyCreateDto.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(enum_1.Permission, { each: true }),
    (0, swagger_1.ApiProperty)({ enum: enum_1.Permission, enumName: 'Permission', isArray: true }),
    (0, class_validator_1.ArrayMinSize)(1),
    __metadata("design:type", Array)
], APIKeyCreateDto.prototype, "permissions", void 0);
class APIKeyUpdateDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String } };
    }
}
exports.APIKeyUpdateDto = APIKeyUpdateDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], APIKeyUpdateDto.prototype, "name", void 0);
class APIKeyCreateResponseDto {
    secret;
    apiKey;
    static _OPENAPI_METADATA_FACTORY() {
        return { secret: { required: true, type: () => String }, apiKey: { required: true, type: () => require("./api-key.dto").APIKeyResponseDto } };
    }
}
exports.APIKeyCreateResponseDto = APIKeyCreateResponseDto;
class APIKeyResponseDto {
    id;
    name;
    createdAt;
    updatedAt;
    permissions;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, permissions: { required: true, enum: require("../enum").Permission, isArray: true } };
    }
}
exports.APIKeyResponseDto = APIKeyResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enum: enum_1.Permission, enumName: 'Permission', isArray: true }),
    __metadata("design:type", Array)
], APIKeyResponseDto.prototype, "permissions", void 0);
//# sourceMappingURL=api-key.dto.js.map