import { AlbumUser, AuthSharedLink, User } from 'src/database';
import { AssetResponseDto, MapAsset } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { UserResponseDto } from 'src/dtos/user.dto';
import { AlbumUserRole, AssetOrder } from 'src/enum';
export declare class AlbumInfoDto {
    withoutAssets?: boolean;
}
export declare class AlbumUserAddDto {
    userId: string;
    role?: AlbumUserRole;
}
export declare class AddUsersDto {
    albumUsers: AlbumUserAddDto[];
}
export declare class AlbumUserCreateDto {
    userId: string;
    role: AlbumUserRole;
}
export declare class CreateAlbumDto {
    albumName: string;
    description?: string;
    albumUsers?: AlbumUserCreateDto[];
    assetIds?: string[];
}
export declare class UpdateAlbumDto {
    albumName?: string;
    description?: string;
    albumThumbnailAssetId?: string;
    isActivityEnabled?: boolean;
    order?: AssetOrder;
}
export declare class GetAlbumsDto {
    shared?: boolean;
    assetId?: string;
}
export declare class AlbumStatisticsResponseDto {
    owned: number;
    shared: number;
    notShared: number;
}
export declare class UpdateAlbumUserDto {
    role: AlbumUserRole;
}
export declare class AlbumUserResponseDto {
    user: UserResponseDto;
    role: AlbumUserRole;
}
export declare class AlbumResponseDto {
    id: string;
    ownerId: string;
    albumName: string;
    description: string;
    createdAt: Date;
    updatedAt: Date;
    albumThumbnailAssetId: string | null;
    shared: boolean;
    albumUsers: AlbumUserResponseDto[];
    hasSharedLink: boolean;
    assets: AssetResponseDto[];
    owner: UserResponseDto;
    assetCount: number;
    lastModifiedAssetTimestamp?: Date;
    startDate?: Date;
    endDate?: Date;
    isActivityEnabled: boolean;
    order?: AssetOrder;
}
export type MapAlbumDto = {
    albumUsers?: AlbumUser[];
    assets?: MapAsset[];
    sharedLinks?: AuthSharedLink[];
    albumName: string;
    description: string;
    albumThumbnailAssetId: string | null;
    createdAt: Date;
    updatedAt: Date;
    id: string;
    ownerId: string;
    owner: User;
    isActivityEnabled: boolean;
    order: AssetOrder;
};
export declare const mapAlbum: (entity: MapAlbumDto, withAssets: boolean, auth?: AuthDto) => AlbumResponseDto;
export declare const mapAlbumWithAssets: (entity: MapAlbumDto) => AlbumResponseDto;
export declare const mapAlbumWithoutAssets: (entity: MapAlbumDto) => AlbumResponseDto;
