import { Activity } from 'src/database';
import { UserResponseDto } from 'src/dtos/user.dto';
export declare enum ReactionType {
    COMMENT = "comment",
    LIKE = "like"
}
export declare enum ReactionLevel {
    ALBUM = "album",
    ASSET = "asset"
}
export type MaybeDuplicate<T> = {
    duplicate: boolean;
    value: T;
};
export declare class ActivityResponseDto {
    id: string;
    createdAt: Date;
    type: ReactionType;
    user: UserResponseDto;
    assetId: string | null;
    comment?: string | null;
}
export declare class ActivityStatisticsResponseDto {
    comments: number;
}
export declare class ActivityDto {
    albumId: string;
    assetId?: string;
}
export declare class ActivitySearchDto extends ActivityDto {
    type?: ReactionType;
    level?: ReactionLevel;
    userId?: string;
}
export declare class ActivityCreateDto extends ActivityDto {
    type: ReactionType;
    comment?: string;
}
export declare const mapActivity: (activity: Activity) => ActivityResponseDto;
