import { ImmichWorker, JobName, MetadataKey, QueueName } from 'src/enum';
import { EmitEvent } from 'src/repositories/event.repository';
import { ColumnOptions } from 'src/sql-tools';
export declare const UpdateIdColumn: (options?: Omit<ColumnOptions, "type" | "default" | "nullable">) => PropertyDecorator;
export declare const PrimaryGeneratedUuidV7Column: () => PropertyDecorator;
export declare const UpdatedAtTrigger: (name: string) => ClassDecorator;
export declare const DATABASE_PARAMETER_CHUNK_SIZE = 65500;
export declare function Chunked(options?: {
    paramIndex?: number;
    chunkSize?: number;
    mergeFn?: (results: any) => any;
}): MethodDecorator;
export declare function ChunkedArray(options?: {
    paramIndex?: number;
}): MethodDecorator;
export declare function ChunkedSet(options?: {
    paramIndex?: number;
}): MethodDecorator;
export declare const DummyValue: {
    UUID: string;
    UUID_SET: Set<string>;
    PAGINATION: {
        take: number;
        skip: number;
    };
    EMAIL: string;
    STRING: string;
    NUMBER: number;
    BUFFER: Buffer<ArrayBuffer>;
    DATE: Date;
    TIME_BUCKET: string;
    BOOLEAN: boolean;
    VECTOR: string;
};
export declare const GENERATE_SQL_KEY = "generate-sql-key";
export interface GenerateSqlQueries {
    name?: string;
    params: unknown[];
    stream?: boolean;
}
export declare const Telemetry: (options: {
    enabled?: boolean;
}) => import("@nestjs/common").CustomDecorator<MetadataKey>;
export declare const GenerateSql: (...options: GenerateSqlQueries[]) => import("@nestjs/common").CustomDecorator<string>;
export type EventConfig = {
    name: EmitEvent;
    server?: boolean;
    priority?: number;
    workers?: ImmichWorker[];
};
export declare const OnEvent: (config: EventConfig) => import("@nestjs/common").CustomDecorator<MetadataKey>;
export type JobConfig = {
    name: JobName;
    queue: QueueName;
};
export declare const OnJob: (config: JobConfig) => import("@nestjs/common").CustomDecorator<MetadataKey>;
type LifecycleRelease = 'NEXT_RELEASE' | string;
type LifecycleMetadata = {
    addedAt?: LifecycleRelease;
    deprecatedAt?: LifecycleRelease;
};
export declare const EndpointLifecycle: ({ addedAt, deprecatedAt }: LifecycleMetadata) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare const PropertyLifecycle: ({ addedAt, deprecatedAt }: LifecycleMetadata) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export {};
