"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.columns = void 0;
const userColumns = ['id', 'name', 'email', 'profileImagePath', 'profileChangedAt'];
exports.columns = {
    asset: [
        'assets.id',
        'assets.checksum',
        'assets.deviceAssetId',
        'assets.deviceId',
        'assets.fileCreatedAt',
        'assets.fileModifiedAt',
        'assets.isExternal',
        'assets.isVisible',
        'assets.libraryId',
        'assets.livePhotoVideoId',
        'assets.localDateTime',
        'assets.originalFileName',
        'assets.originalPath',
        'assets.ownerId',
        'assets.sidecarPath',
        'assets.type',
    ],
    assetFiles: ['asset_files.id', 'asset_files.path', 'asset_files.type'],
    authUser: [
        'users.id',
        'users.name',
        'users.email',
        'users.isAdmin',
        'users.quotaUsageInBytes',
        'users.quotaSizeInBytes',
    ],
    authApiKey: ['api_keys.id', 'api_keys.permissions'],
    authSession: ['sessions.id', 'sessions.updatedAt'],
    authSharedLink: [
        'shared_links.id',
        'shared_links.userId',
        'shared_links.expiresAt',
        'shared_links.showExif',
        'shared_links.allowUpload',
        'shared_links.allowDownload',
        'shared_links.password',
    ],
    user: userColumns,
    userWithPrefix: ['users.id', 'users.name', 'users.email', 'users.profileImagePath', 'users.profileChangedAt'],
    userAdmin: [
        ...userColumns,
        'createdAt',
        'updatedAt',
        'deletedAt',
        'isAdmin',
        'status',
        'oauthId',
        'profileImagePath',
        'shouldChangePassword',
        'storageLabel',
        'quotaSizeInBytes',
        'quotaUsageInBytes',
    ],
    tag: ['tags.id', 'tags.value', 'tags.createdAt', 'tags.updatedAt', 'tags.color', 'tags.parentId'],
    apiKey: ['id', 'name', 'userId', 'createdAt', 'updatedAt', 'permissions'],
    syncAsset: [
        'id',
        'ownerId',
        'thumbhash',
        'checksum',
        'fileCreatedAt',
        'fileModifiedAt',
        'localDateTime',
        'type',
        'deletedAt',
        'isFavorite',
        'isVisible',
        'updateId',
    ],
    stack: ['stack.id', 'stack.primaryAssetId', 'ownerId'],
    syncAssetExif: [
        'exif.assetId',
        'exif.description',
        'exif.exifImageWidth',
        'exif.exifImageHeight',
        'exif.fileSizeInByte',
        'exif.orientation',
        'exif.dateTimeOriginal',
        'exif.modifyDate',
        'exif.timeZone',
        'exif.latitude',
        'exif.longitude',
        'exif.projectionType',
        'exif.city',
        'exif.state',
        'exif.country',
        'exif.make',
        'exif.model',
        'exif.lensModel',
        'exif.fNumber',
        'exif.focalLength',
        'exif.iso',
        'exif.exposureTime',
        'exif.profileDescription',
        'exif.rating',
        'exif.fps',
        'exif.updateId',
    ],
    exif: [
        'exif.assetId',
        'exif.autoStackId',
        'exif.bitsPerSample',
        'exif.city',
        'exif.colorspace',
        'exif.country',
        'exif.dateTimeOriginal',
        'exif.description',
        'exif.exifImageHeight',
        'exif.exifImageWidth',
        'exif.exposureTime',
        'exif.fileSizeInByte',
        'exif.fNumber',
        'exif.focalLength',
        'exif.fps',
        'exif.iso',
        'exif.latitude',
        'exif.lensModel',
        'exif.livePhotoCID',
        'exif.longitude',
        'exif.make',
        'exif.model',
        'exif.modifyDate',
        'exif.orientation',
        'exif.profileDescription',
        'exif.projectionType',
        'exif.rating',
        'exif.state',
        'exif.timeZone',
    ],
};
//# sourceMappingURL=database.js.map